/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Singleton {

    public static class Instantiator<A> {
        private static final Logger logger = Logger.getLogger(Instantiator.class.getName());
        private volatile Map<Class<? extends A>, A> instances = new HashMap<Class<? extends A>, A>();
        private final A defaultValue;
        private final Function<Class<? extends A>, A> instantiator = new Function<Class<? extends A>, A>(){

            public A apply(Class<? extends A> clazz) {
                try {
                    if (clazz.getAnnotation(Singleton.class) != null) {
                        if (!Instantiator.this.instances.containsKey(clazz)) {
                            Instantiator.this.instances.put(clazz, clazz.newInstance());
                        }
                        return Instantiator.this.instances.get(clazz);
                    }
                    return clazz.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.log(Level.WARNING, "Could not instantiate: " + clazz.getName());
                    return null;
                }
            }
        };

        public Instantiator(A defaultValue) {
            this.defaultValue = defaultValue;
        }

        public A getInstanceOrDefault(Class<? extends A> clazz) {
            return (A)(clazz == null ? this.defaultValue : this.instantiator.apply(clazz));
        }

        public Iterable<A> getInstancesOrDefault(List<Class<? extends A>> classes) {
            return classes == null ? ImmutableList.of(this.defaultValue) : Iterables.filter((Iterable)Iterables.transform(classes, this.instantiator), (Predicate)Predicates.notNull());
        }
    }
}

