/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpressions;
import com.google.api.server.spi.discovery.DiscoveryGenerator;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class AuthScopeRepository {
    private static final ImmutableMap<String, String> GOOGLE_SCOPE_DESCRIPTIONS = AuthScopeRepository.loadScopeDescriptions("googleScopeDescriptions.properties");
    private final SortedMap<String, String> descriptionsByScope = new TreeMap<String, String>();

    private static ImmutableMap<String, String> loadScopeDescriptions(String fileName) {
        try {
            Properties properties = new Properties();
            URL resourceFile = Resources.getResource(DiscoveryGenerator.class, (String)fileName);
            InputStream inputStream = resourceFile.openStream();
            properties.load(inputStream);
            inputStream.close();
            return Maps.fromProperties((Properties)properties);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load scope descriptions from " + fileName, e);
        }
    }

    public AuthScopeRepository() {
        this.add(AuthScopeExpressions.interpret("https://www.googleapis.com/auth/userinfo.email"));
    }

    public void add(AuthScopeExpression scopeExpression) {
        for (String scope : scopeExpression.getAllScopes()) {
            String description = (String)MoreObjects.firstNonNull((Object)GOOGLE_SCOPE_DESCRIPTIONS.get((Object)scope), (Object)scope);
            this.descriptionsByScope.put(scope, description);
        }
    }

    public SortedMap<String, String> getDescriptionsByScope() {
        return this.descriptionsByScope;
    }
}

