/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.model;

import com.google.common.annotations.VisibleForTesting;

public enum EndpointsFlag {
    MAP_SCHEMA_FORCE_JSON_MAP_SCHEMA("mapSchema.forceJsonMapSchema", false),
    MAP_SCHEMA_IGNORE_UNSUPPORTED_KEY_TYPES("mapSchema.ignoreUnsupportedKeyTypes", false),
    MAP_SCHEMA_SUPPORT_ARRAYS_VALUES("mapSchema.supportArrayValues", false),
    JSON_USE_JACKSON_ANNOTATIONS("json.useJacksonAnnotations", true);

    private static final String ENV_VARIABLE_PREFIX = "ENDPOINTS_";
    private static final String SYSTEM_PROPERTY_PREFIX = "endpoints.";
    @VisibleForTesting
    public String envVarName = "ENDPOINTS_" + this.name();
    @VisibleForTesting
    public String systemPropertyName;
    private boolean defaultValue;

    private EndpointsFlag(String systemPropertySuffix, boolean defaultValue) {
        this.systemPropertyName = SYSTEM_PROPERTY_PREFIX + systemPropertySuffix;
        this.defaultValue = defaultValue;
    }

    public boolean isEnabled() {
        String envVar = System.getenv(this.envVarName);
        String systemProperty = System.getProperty(this.systemPropertyName);
        if (systemProperty != null) {
            return !"false".equalsIgnoreCase(systemProperty);
        }
        if (envVar != null) {
            return !"false".equalsIgnoreCase(envVar);
        }
        return this.defaultValue;
    }
}

