/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.dispatcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;

enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    PATCH;

    private static final ImmutableMap<String, HttpMethod> STRING_TO_ENUM;

    public static HttpMethod fromString(String method) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        return (HttpMethod)((Object)STRING_TO_ENUM.get((Object)method.toUpperCase()));
    }

    static {
        STRING_TO_ENUM = ImmutableMap.builder().put((Object)"GET", (Object)GET).put((Object)"POST", (Object)POST).put((Object)"PUT", (Object)PUT).put((Object)"DELETE", (Object)DELETE).put((Object)"PATCH", (Object)PATCH).build();
    }
}

