/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.response;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.api.client.util.DateTime;
import com.google.api.server.spi.ConfiguredObjectMapper;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.response.EndpointsPrettyPrinter;
import com.google.api.server.spi.response.ResponseUtil;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.types.DateAndTime;
import com.google.api.server.spi.types.SimpleDate;
import com.google.appengine.api.datastore.Blob;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public class ServletResponseResultWriter
implements ResultWriter {
    private static final Set<SimpleModule> WRITER_MODULES;
    private final HttpServletResponse servletResponse;
    private final ObjectWriter objectWriter;
    private final boolean addContentLength;

    public ServletResponseResultWriter(HttpServletResponse servletResponse, ApiSerializationConfig serializationConfig) {
        this(servletResponse, serializationConfig, false, false);
    }

    public ServletResponseResultWriter(HttpServletResponse servletResponse, ApiSerializationConfig serializationConfig, boolean prettyPrint, boolean addContentLength) {
        this.servletResponse = servletResponse;
        LinkedHashSet<SimpleModule> modules = new LinkedHashSet<SimpleModule>();
        modules.addAll(WRITER_MODULES);
        ObjectWriter objectWriter = ConfiguredObjectMapper.builder().apiSerializationConfig(serializationConfig).addRegisteredModules(modules).build().writer();
        if (prettyPrint) {
            objectWriter = objectWriter.with((PrettyPrinter)new EndpointsPrettyPrinter());
        }
        this.objectWriter = this.configureWriter(objectWriter);
        this.addContentLength = addContentLength;
    }

    protected ObjectWriter configureWriter(ObjectWriter objectWriter) {
        return objectWriter;
    }

    @Override
    public void write(Object response) throws IOException {
        if (response == null) {
            this.write(204, null, null);
        } else {
            this.write(200, null, ResponseUtil.wrapCollection(response));
        }
    }

    @Override
    public void writeError(ServiceException e) throws IOException {
        HashMap<String, String> errors = new HashMap<String, String>();
        errors.put("error_message", e.getMessage());
        this.write(e.getStatusCode(), e.getHeaders(), errors);
    }

    protected void write(int status, Map<String, String> headers, Object content) throws IOException {
        this.servletResponse.setStatus(status);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.servletResponse.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (content != null) {
            this.servletResponse.setContentType("application/json; charset=UTF-8");
            if (this.addContentLength) {
                CountingOutputStream counter = new CountingOutputStream(ByteStreams.nullOutputStream());
                this.objectWriter.writeValue((OutputStream)counter, content);
                this.servletResponse.setContentLength((int)counter.getCount());
            }
            this.objectWriter.writeValue((OutputStream)this.servletResponse.getOutputStream(), content);
        }
    }

    private static SimpleModule getWriteLongAsStringModule() {
        JsonSerializer<Long> longSerializer = new JsonSerializer<Long>(){

            public void serialize(Long value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.toString());
            }
        };
        SimpleModule writeLongAsStringModule = new SimpleModule("writeLongAsStringModule", new Version(1, 0, 0, null, null, null));
        writeLongAsStringModule.addSerializer(Long.TYPE, (JsonSerializer)longSerializer);
        writeLongAsStringModule.addSerializer(Long.class, (JsonSerializer)longSerializer);
        return writeLongAsStringModule;
    }

    private static SimpleModule getWriteDateAndTimeAsStringModule() {
        JsonSerializer<DateAndTime> dateAndTimeSerializer = new JsonSerializer<DateAndTime>(){

            public void serialize(DateAndTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(value.toRfc3339String());
            }
        };
        SimpleModule writeDateAsStringModule = new SimpleModule("writeDateAsStringModule", new Version(1, 0, 0, null, null, null));
        writeDateAsStringModule.addSerializer(DateAndTime.class, (JsonSerializer)dateAndTimeSerializer);
        return writeDateAsStringModule;
    }

    private static SimpleModule getWriteSimpleDateAsStringModule() {
        JsonSerializer<SimpleDate> simpleDateSerializer = new JsonSerializer<SimpleDate>(){

            public void serialize(SimpleDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(String.format("%04d-%02d-%02d", value.getYear(), value.getMonth(), value.getDay()));
            }
        };
        SimpleModule writeSimpleDateAsModule = new SimpleModule("writeSimpleDateAsModule", new Version(1, 0, 0, null, null, null));
        writeSimpleDateAsModule.addSerializer(SimpleDate.class, (JsonSerializer)simpleDateSerializer);
        return writeSimpleDateAsModule;
    }

    private static SimpleModule getWriteDateAsStringModule() {
        JsonSerializer<Date> dateSerializer = new JsonSerializer<Date>(){

            public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                jgen.writeString(new DateTime(value).toStringRfc3339());
            }
        };
        SimpleModule writeDateAsStringModule = new SimpleModule("writeDateAsStringModule", new Version(1, 0, 0, null, null, null));
        writeDateAsStringModule.addSerializer(Date.class, (JsonSerializer)dateSerializer);
        return writeDateAsStringModule;
    }

    private static SimpleModule getWriteBlobAsBase64Module() {
        JsonSerializer<Blob> dateSerializer = new JsonSerializer<Blob>(){

            public void serialize(Blob value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                byte[] bytes = value.getBytes();
                jgen.writeBinary(bytes, 0, bytes.length);
            }
        };
        SimpleModule writeBlobAsBase64Module = new SimpleModule("writeBlobAsBase64Module", new Version(1, 0, 0, null, null, null));
        writeBlobAsBase64Module.addSerializer(Blob.class, (JsonSerializer)dateSerializer);
        return writeBlobAsBase64Module;
    }

    static {
        LinkedHashSet<SimpleModule> modules = new LinkedHashSet<SimpleModule>();
        modules.add(ServletResponseResultWriter.getWriteLongAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteDateAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteDateAndTimeAsStringModule());
        modules.add(ServletResponseResultWriter.getWriteSimpleDateAsStringModule());
        try {
            ServletResponseResultWriter.class.getClassLoader().loadClass("com.google.appengine.api.datastore.Blob");
            modules.add(ServletResponseResultWriter.getWriteBlobAsBase64Module());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        WRITER_MODULES = Collections.unmodifiableSet(modules);
    }
}

