/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.EnvUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.FluentLogger;
import javax.annotation.Nullable;

public class BackendProperties {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    static final String APP_ID_PROPERTY = "com.google.appengine.application.id";
    static final String PROJECT_NUMBER_PROPERTY = "GOOGLE_PROJECT_NUMBER";
    static final String GCLOUD_PROJECT_PROPERTY = "GCLOUD_PROJECT";
    static final long PROJECT_NUMBER_UNKNOWN = 0L;
    static final String PROJECT_ID_PROPERTY = "GOOGLE_PROJECT_ID";
    private boolean isOnAppEngine;
    private EnvReader envReader;

    public BackendProperties() {
        this(EnvUtil.isRunningOnAppEngine(), new EnvReader());
    }

    @VisibleForTesting
    BackendProperties(boolean isAppEngine, EnvReader envReader) {
        this.isOnAppEngine = isAppEngine;
        this.envReader = envReader;
    }

    public boolean isOnAppEngine() {
        return this.isOnAppEngine;
    }

    public long getProjectNumber() {
        if (this.isOnAppEngine()) {
            return 0L;
        }
        if (this.envReader.getenv(PROJECT_NUMBER_PROPERTY) != null) {
            String property = this.envReader.getenv(PROJECT_NUMBER_PROPERTY);
            try {
                return Long.parseLong(property);
            }
            catch (NumberFormatException e) {
                ((FluentLogger.Api)logger.atWarning()).log("Project number (%s) is not an int64.", (Object)property);
                return 0L;
            }
        }
        return 0L;
    }

    @Nullable
    public String getProjectId() {
        if (this.isOnAppEngine()) {
            return null;
        }
        return this.envReader.getenv(PROJECT_ID_PROPERTY);
    }

    @Nullable
    public String getApplicationId() {
        if (this.isOnAppEngine()) {
            String appId = System.getProperty(APP_ID_PROPERTY);
            if (appId == null) {
                appId = this.envReader.getenv(GCLOUD_PROJECT_PROPERTY);
            }
            return appId;
        }
        return null;
    }

    @VisibleForTesting
    static class EnvReader {
        EnvReader() {
        }

        public String getenv(String name) {
            return System.getenv(name);
        }
    }
}

