/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.discovery;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.Api;
import com.google.api.server.spi.config.ApiMethod;
import com.google.api.server.spi.config.Named;
import com.google.api.server.spi.discovery.DiscoveryProvider;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.NotFoundException;
import com.google.api.services.discovery.model.DirectoryList;
import com.google.api.services.discovery.model.RestDescription;
import com.google.api.services.discovery.model.RpcDescription;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.FluentLogger;
import javax.servlet.http.HttpServletRequest;

@Api(name="discovery", version="v1", title="APIs Discovery Service", description="Lets you discover information about other Google APIs, such as what APIs are available, the resource and method details for each API")
public class ProxyingDiscoveryService {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private DiscoveryProvider discoveryProvider;
    private boolean initialized = false;

    @ApiMethod(ignored=AnnotationBoolean.TRUE)
    public synchronized void initialize(DiscoveryProvider discoveryProvider) {
        if (!this.initialized) {
            this.discoveryProvider = discoveryProvider;
            this.initialized = true;
        }
    }

    @ApiMethod(name="apis.getRest", path="apis/{api}/{version}/rest")
    public RestDescription getRestDocument(HttpServletRequest request, @Named(value="api") String name, @Named(value="version") String version) throws NotFoundException, InternalServerErrorException {
        this.checkIsInitialized();
        return this.discoveryProvider.getRestDocument(ProxyingDiscoveryService.getActualRoot(request), name, version);
    }

    @ApiMethod(name="apis.getRpc", path="apis/{api}/{version}/rpc")
    public RpcDescription getRpcDocument(HttpServletRequest request, @Named(value="api") String name, @Named(value="version") String version) throws NotFoundException, InternalServerErrorException {
        this.checkIsInitialized();
        return this.discoveryProvider.getRpcDocument(ProxyingDiscoveryService.getActualRoot(request), name, version);
    }

    @ApiMethod(name="apis.list", path="apis")
    public DirectoryList getApiList(HttpServletRequest request) throws InternalServerErrorException {
        this.checkIsInitialized();
        return this.discoveryProvider.getDirectory(ProxyingDiscoveryService.getActualRoot(request));
    }

    private void checkIsInitialized() throws InternalServerErrorException {
        if (!this.initialized) {
            ((FluentLogger.Api)logger.atWarning()).log("Tried to call discovery before initialization!");
            throw new InternalServerErrorException("Internal Server Error");
        }
    }

    @VisibleForTesting
    static String getActualRoot(HttpServletRequest request) throws InternalServerErrorException {
        String uri = request.getRequestURI();
        int index = uri.indexOf("discovery/v1/apis");
        if (index == -1) {
            ((FluentLogger.Api)logger.atSevere()).log("Could not compute discovery root from url: %s", (Object)request.getRequestURI());
            throw new InternalServerErrorException("Internal Server Error");
        }
        StringBuffer url = request.getRequestURL();
        return url.substring(0, url.length() - (uri.length() - index));
    }
}

