/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.handlers;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.EndpointsContext;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.ServletInitializationParameters;
import com.google.api.server.spi.SystemService;
import com.google.api.server.spi.config.model.ApiConfig;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.config.model.ApiSerializationConfig;
import com.google.api.server.spi.config.model.StandardParameters;
import com.google.api.server.spi.dispatcher.DispatcherHandler;
import com.google.api.server.spi.handlers.CorsHandler;
import com.google.api.server.spi.request.Attribute;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.request.RestServletRequestParamReader;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.RestResponseResultWriter;
import com.google.api.server.spi.response.ResultWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flogger.FluentLogger;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EndpointsMethodHandler {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final ServletInitializationParameters initParameters;
    private final ServletContext servletContext;
    private final EndpointMethod endpointMethod;
    private final ApiMethodConfig methodConfig;
    private final SystemService systemService;
    private final RestHandler restHandler;
    private final String restPath;

    public EndpointsMethodHandler(ServletInitializationParameters initParameters, ServletContext servletContext, EndpointMethod endpointMethod, ApiMethodConfig methodConfig, SystemService systemService) {
        this.initParameters = initParameters;
        this.servletContext = servletContext;
        this.endpointMethod = endpointMethod;
        this.methodConfig = methodConfig;
        this.systemService = systemService;
        this.restHandler = new RestHandler();
        this.restPath = EndpointsMethodHandler.createRestPath(methodConfig);
    }

    public String getRestMethod() {
        return this.methodConfig.getHttpMethod();
    }

    public String getRestPath() {
        return this.restPath;
    }

    public DispatcherHandler<EndpointsContext> getRestHandler() {
        return this.restHandler;
    }

    @VisibleForTesting
    protected ParamReader createRestParamReader(EndpointsContext context, ApiSerializationConfig serializationConfig) {
        return new RestServletRequestParamReader(this.endpointMethod, context, this.servletContext, serializationConfig, this.methodConfig);
    }

    protected ResultWriter createResultWriter(EndpointsContext context, ApiSerializationConfig serializationConfig) throws ServiceException {
        return this._createResultWriter(context, serializationConfig);
    }

    private void writeError(EndpointsContext context, ServiceException error) throws IOException {
        this._createResultWriter(context, null).writeError(error);
    }

    private ResultWriter _createResultWriter(EndpointsContext context, ApiSerializationConfig serializationConfig) {
        return new RestResponseResultWriter(context.getResponse(), serializationConfig, StandardParameters.shouldPrettyPrint(context), this.initParameters.isAddContentLength(), this.initParameters.isExceptionCompatibilityEnabled());
    }

    private static String createRestPath(ApiMethodConfig methodConfig) {
        if (methodConfig.getPath().startsWith("/")) {
            return methodConfig.getPath().substring(1);
        }
        ApiConfig apiConfig = methodConfig.getApiConfig();
        return String.format("%s/%s/%s", apiConfig.getName(), apiConfig.getVersion(), methodConfig.getPath());
    }

    private class RestHandler
    implements DispatcherHandler<EndpointsContext> {
        private RestHandler() {
        }

        @Override
        public void handle(EndpointsContext context) throws IOException {
            try {
                HttpServletRequest request = context.getRequest();
                Attribute.bindStandardRequestAttributes(request, EndpointsMethodHandler.this.methodConfig, EndpointsMethodHandler.this.initParameters);
                String serviceName = EndpointsMethodHandler.this.endpointMethod.getEndpointClass().getName();
                Object service = EndpointsMethodHandler.this.systemService.findService(serviceName);
                ApiSerializationConfig serializationConfig = EndpointsMethodHandler.this.systemService.getSerializationConfig(serviceName);
                ParamReader reader = EndpointsMethodHandler.this.createRestParamReader(context, serializationConfig);
                ResultWriter writer = EndpointsMethodHandler.this.createResultWriter(context, serializationConfig);
                if (request.getHeader("Origin") != null) {
                    HttpServletResponse response = context.getResponse();
                    CorsHandler.allowOrigin(request, response);
                    CorsHandler.setAccessControlAllowCredentials(response);
                }
                EndpointsMethodHandler.this.systemService.invokeServiceMethod(service, EndpointsMethodHandler.this.endpointMethod.getMethod(), reader, writer);
            }
            catch (ServiceException e) {
                EndpointsMethodHandler.this.writeError(context, e);
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause((Throwable)e)).log("exception occurred while invoking backend method");
                EndpointsMethodHandler.this.writeError(context, new InternalServerErrorException("backend error"));
            }
        }
    }
}

