/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.request;

import com.google.api.server.spi.EnvUtil;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.auth.EndpointsAuthenticator;
import com.google.api.server.spi.config.Authenticator;
import com.google.api.server.spi.config.Singleton;
import com.google.api.server.spi.config.model.ApiMethodConfig;
import com.google.api.server.spi.request.Attribute;
import com.google.appengine.api.users.User;
import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class Auth {
    private static final Singleton.Instantiator<Authenticator> INSTANTIATOR = new Singleton.Instantiator<EndpointsAuthenticator>(new EndpointsAuthenticator());
    private final HttpServletRequest request;
    private final Attribute attr;
    private final ApiMethodConfig config;

    public static Authenticator instantiateAuthenticator(Class<? extends Authenticator> clazz) {
        return INSTANTIATOR.getInstanceOrDefault(clazz);
    }

    @VisibleForTesting
    Auth(HttpServletRequest request) {
        this.request = request;
        this.attr = Attribute.from(request);
        this.config = (ApiMethodConfig)this.attr.get("endpoints:Api-Method-Config");
    }

    static Auth from(HttpServletRequest request) {
        return new Auth(request);
    }

    @VisibleForTesting
    Iterable<Authenticator> getAuthenticatorInstances() {
        return INSTANTIATOR.getInstancesOrDefault(this.config.getAuthenticators());
    }

    com.google.api.server.spi.auth.common.User authenticate() throws ServiceException {
        com.google.api.server.spi.auth.common.User user;
        block1: {
            Authenticator authenticator;
            Iterable<Authenticator> authenticators = this.getAuthenticatorInstances();
            user = null;
            if (authenticators == null) break block1;
            Iterator<Authenticator> iterator = authenticators.iterator();
            while (iterator.hasNext() && (user = (authenticator = iterator.next()).authenticate(this.request)) == null) {
            }
        }
        return user;
    }

    User authenticateAppEngineUser() throws ServiceException {
        if (!EnvUtil.isRunningOnAppEngine()) {
            return null;
        }
        this.attr.set("endpoints:Require-AppEngine-User", true);
        com.google.api.server.spi.auth.common.User user = this.authenticate();
        this.attr.set("endpoints:Require-AppEngine-User", false);
        if (user == null) {
            return null;
        }
        User appEngineUser = (User)this.attr.get("endpoints:Authenticated-AppEngine-User");
        if (appEngineUser != null) {
            return appEngineUser;
        }
        return user.getEmail() == null ? null : new User(user.getEmail(), "", user.getId());
    }
}

