/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.AuthTokenDecoder;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.cache.CacheBuilder;
import endpoints.repackaged.com.google.common.cache.CacheLoader;
import endpoints.repackaged.com.google.common.cache.LoadingCache;
import endpoints.repackaged.org.jose4j.jwt.JwtClaims;
import java.util.concurrent.TimeUnit;

public class CachingAuthTokenDecoder
implements AuthTokenDecoder {
    private static final int CACHE_CAPACITY = 200;
    private static final int CACHE_EXPIRATION_IN_MINUTES = 5;
    private final LoadingCache<String, JwtClaims> authTokenCache;

    public CachingAuthTokenDecoder(AuthTokenDecoder authTokenDecoder) {
        this(authTokenDecoder, Ticker.systemTicker());
    }

    @VisibleForTesting
    CachingAuthTokenDecoder(AuthTokenDecoder authTokenDecoder, Ticker ticker) {
        this.authTokenCache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(5L, TimeUnit.MINUTES).ticker(ticker).build(new DefaultCacheLoader(authTokenDecoder));
    }

    @Override
    public JwtClaims decode(String authToken) {
        Preconditions.checkNotNull(authToken);
        return this.authTokenCache.getUnchecked(authToken);
    }

    private static final class DefaultCacheLoader
    extends CacheLoader<String, JwtClaims> {
        private final AuthTokenDecoder authTokenDecoder;

        DefaultCacheLoader(AuthTokenDecoder authTokenDecoder) {
            this.authTokenDecoder = authTokenDecoder;
        }

        @Override
        public JwtClaims load(String authToken) throws Exception {
            return this.authTokenDecoder.decode(authToken);
        }
    }
}

