/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.JwksSupplier;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.cache.CacheBuilder;
import endpoints.repackaged.com.google.common.cache.CacheLoader;
import endpoints.repackaged.com.google.common.cache.LoadingCache;
import endpoints.repackaged.org.jose4j.jwk.JsonWebKeySet;
import java.util.concurrent.TimeUnit;

public class CachingJwksSupplier
implements JwksSupplier {
    private static final int CACHE_EXPIRATION_IN_MINUTES = 5;
    private final LoadingCache<String, JsonWebKeySet> jwksCache;

    public CachingJwksSupplier(JwksSupplier jwksSupplier) {
        this(Preconditions.checkNotNull(jwksSupplier), Ticker.systemTicker());
    }

    @VisibleForTesting
    CachingJwksSupplier(JwksSupplier jwksSupplier, Ticker ticker) {
        this.jwksCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).ticker(ticker).build(new JwksCacheLoader(jwksSupplier));
    }

    @Override
    public JsonWebKeySet supply(String issuer) {
        Preconditions.checkNotNull(issuer);
        return this.jwksCache.getUnchecked(issuer);
    }

    private static final class JwksCacheLoader
    extends CacheLoader<String, JsonWebKeySet> {
        private final JwksSupplier jwksSupplier;

        JwksCacheLoader(JwksSupplier jwksSupplier) {
            this.jwksSupplier = jwksSupplier;
        }

        @Override
        public JsonWebKeySet load(String issuer) throws Exception {
            return this.jwksSupplier.supply(issuer);
        }
    }
}

