/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.AuthTokenVerifier;
import com.google.api.auth.JwksSupplier;
import com.google.api.auth.UnauthenticatedException;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.org.jose4j.jwk.JsonWebKey;
import endpoints.repackaged.org.jose4j.jwk.JsonWebKeySet;
import endpoints.repackaged.org.jose4j.jwk.VerificationJwkSelector;
import endpoints.repackaged.org.jose4j.jws.JsonWebSignature;
import endpoints.repackaged.org.jose4j.lang.JoseException;

public class DefaultAuthTokenVerifier
implements AuthTokenVerifier {
    private final VerificationJwkSelector jwkSelector = new VerificationJwkSelector();
    private final JwksSupplier jwksSupplier;

    public DefaultAuthTokenVerifier(JwksSupplier jwksSupplier) {
        this.jwksSupplier = Preconditions.checkNotNull(jwksSupplier);
    }

    @Override
    public boolean verify(String authToken, String issuer) {
        Preconditions.checkNotNull(authToken);
        Preconditions.checkNotNull(issuer);
        try {
            JsonWebKeySet jwks = this.jwksSupplier.supply(issuer);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setCompactSerialization(authToken);
            for (JsonWebKey jwk : this.jwkSelector.selectList(jws, jwks.getJsonWebKeys())) {
                jws.setKey(jwk.getKey());
                if (!jws.verifySignature()) continue;
                return true;
            }
        }
        catch (JoseException exception) {
            throw new UnauthenticatedException("Cannot verify the signature", exception);
        }
        return false;
    }
}

