/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.IssuerKeyUrlConfig;
import com.google.api.auth.KeyUriSupplier;
import com.google.api.auth.UnauthenticatedException;
import endpoints.repackaged.com.fasterxml.jackson.annotation.JsonProperty;
import endpoints.repackaged.com.fasterxml.jackson.databind.ObjectMapper;
import endpoints.repackaged.com.google.api.client.http.GenericUrl;
import endpoints.repackaged.com.google.api.client.http.HttpRequestFactory;
import endpoints.repackaged.com.google.api.client.http.HttpResponse;
import endpoints.repackaged.com.google.common.base.Optional;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultKeyUriSupplier
implements KeyUriSupplier {
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String OPEN_ID_CONFIG_PATH = ".well-known/openid-configuration";
    private final HttpRequestFactory httpRequestFactory;
    private final Map<String, IssuerKeyUrlConfig> issuerKeyUrls;

    public DefaultKeyUriSupplier(HttpRequestFactory httpRequestFactory, Map<String, IssuerKeyUrlConfig> issuerKeyUrls) {
        Preconditions.checkNotNull(httpRequestFactory);
        Preconditions.checkNotNull(issuerKeyUrls);
        this.httpRequestFactory = httpRequestFactory;
        this.issuerKeyUrls = new ConcurrentHashMap<String, IssuerKeyUrlConfig>(issuerKeyUrls);
    }

    @Override
    public Optional<GenericUrl> supply(String issuer) {
        Preconditions.checkNotNull(issuer);
        if (!this.issuerKeyUrls.containsKey(issuer)) {
            return Optional.absent();
        }
        IssuerKeyUrlConfig issuerKeyUrlConfig = this.issuerKeyUrls.get(issuer);
        Optional<GenericUrl> jwksUri = issuerKeyUrlConfig.getJwksUri();
        if (jwksUri.isPresent()) {
            return jwksUri;
        }
        boolean openIdValid = issuerKeyUrlConfig.isOpenIdValid();
        if (openIdValid) {
            Optional<GenericUrl> discoveredJwksUri = this.discoverJwksUri(issuer);
            this.issuerKeyUrls.put(issuer, new IssuerKeyUrlConfig(false, discoveredJwksUri));
            return discoveredJwksUri;
        }
        return Optional.absent();
    }

    private Optional<GenericUrl> discoverJwksUri(String issuer) {
        String openIdUrl = DefaultKeyUriSupplier.constructOpenIdUrl(issuer);
        GenericUrl jwksUri = this.retrieveRemoteJwksUri(openIdUrl);
        return Optional.of(jwksUri);
    }

    private GenericUrl retrieveRemoteJwksUri(String openIdUrl) {
        try {
            GenericUrl genericUrl = new GenericUrl(openIdUrl);
            HttpResponse httpResponse = this.httpRequestFactory.buildGetRequest(genericUrl).execute();
            String json = httpResponse.parseAsString();
            ProviderMetadata metadata = OBJECT_MAPPER.readValue(json, ProviderMetadata.class);
            return new GenericUrl(metadata.getJwksUri());
        }
        catch (IOException exception) {
            throw new UnauthenticatedException("Cannot retrieve or parse OpenId Provider Metadata", exception);
        }
    }

    private static String constructOpenIdUrl(String issuer) {
        String url = issuer;
        if (!URI.create(issuer).isAbsolute()) {
            url = HTTPS_PROTOCOL_PREFIX + issuer;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url + OPEN_ID_CONFIG_PATH;
    }

    private static final class ProviderMetadata {
        private final String jwksUri;

        ProviderMetadata(@JsonProperty(value="jwks_uri") String jwksUri) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(jwksUri));
            this.jwksUri = jwksUri;
        }

        String getJwksUri() {
            return this.jwksUri;
        }
    }
}

