/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control;

import com.google.api.control.aggregator.CheckAggregationOptions;
import com.google.api.control.aggregator.CheckRequestAggregator;
import com.google.api.control.aggregator.QuotaAggregationOptions;
import com.google.api.control.aggregator.QuotaRequestAggregator;
import com.google.api.control.aggregator.ReportAggregationOptions;
import com.google.api.control.aggregator.ReportRequestAggregator;
import endpoints.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import endpoints.repackaged.com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import endpoints.repackaged.com.google.api.client.http.HttpHeaders;
import endpoints.repackaged.com.google.api.client.http.HttpRequest;
import endpoints.repackaged.com.google.api.client.http.HttpRequestInitializer;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.json.jackson2.JacksonFactory;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.ReportRequest;
import endpoints.repackaged.com.google.api.services.servicecontrol.v1.ServiceControl;
import endpoints.repackaged.com.google.api.services.servicecontrol.v1.ServiceControlScopes;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Stopwatch;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.collect.Queues;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import endpoints.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public class Client {
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private static final String CLIENT_APPLICATION_NAME = "Service Control Client";
    private static final String BACKGROUND_THREAD_ERROR = "The scheduler thread was unable to start. This means that metric reporting will only be done periodically after requests are served. If your API is low-traffic (below 1 query per second), this may result in delays in reporting.";
    private static final int MAX_IDLE_TIME_SECONDS = 120;
    public static final int DO_NOT_LOG_STATS = -1;
    public static final SchedulerFactory DEFAULT_SCHEDULER_FACTORY = new SchedulerFactory(){

        @Override
        public Scheduler create(Ticker ticker) {
            return new Scheduler(ticker);
        }
    };
    private final CheckRequestAggregator checkAggregator;
    private final ReportRequestAggregator reportAggregator;
    private final QuotaRequestAggregator quotaAggregator;
    private final Ticker ticker;
    private final ThreadFactory threads;
    private final SchedulerFactory schedulers;
    private final ServiceControl transport;
    private boolean running;
    private boolean stopped;
    private Scheduler scheduler;
    private String serviceName;
    private Statistics statistics;
    private Thread schedulerThread;
    private int statsLogFrequency;
    private final Stopwatch reportStopwatch;

    public Client(String serviceName, CheckAggregationOptions checkOptions, ReportAggregationOptions reportOptions, QuotaAggregationOptions quotaOptions, ServiceControl transport, ThreadFactory threads, SchedulerFactory schedulers, int statsLogFrequency, @Nullable Ticker ticker) {
        ticker = ticker == null ? Ticker.systemTicker() : ticker;
        this.checkAggregator = new CheckRequestAggregator(serviceName, checkOptions, null, ticker);
        this.reportAggregator = new ReportRequestAggregator(serviceName, reportOptions, null, ticker);
        this.quotaAggregator = new QuotaRequestAggregator(serviceName, quotaOptions, ticker);
        this.serviceName = serviceName;
        this.ticker = ticker;
        this.transport = transport;
        this.threads = threads;
        this.schedulers = schedulers;
        this.scheduler = null;
        this.schedulerThread = null;
        this.statsLogFrequency = statsLogFrequency;
        this.statistics = new Statistics();
        this.reportStopwatch = Stopwatch.createUnstarted(ticker);
    }

    public synchronized void start() {
        if (this.running) {
            ((FluentLogger.Api)log.atInfo()).log("%s is already started", this);
            return;
        }
        ((FluentLogger.Api)log.atInfo()).log("starting %s", this);
        this.stopped = false;
        this.running = true;
        this.reportStopwatch.reset().start();
        try {
            this.schedulerThread = this.threads.newThread(new Runnable(){

                @Override
                public void run() {
                    Client.this.scheduleFlushes();
                }
            });
            this.schedulerThread.start();
        }
        catch (RuntimeException e) {
            ((FluentLogger.Api)log.atInfo()).log(BACKGROUND_THREAD_ERROR);
            this.schedulerThread = null;
            this.initializeFlushing();
        }
    }

    public synchronized void startIfStopped() {
        if (!this.running) {
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Preconditions.checkState(this.running, "Cannot stop if it's not running");
        Client client = this;
        synchronized (client) {
            ((FluentLogger.Api)log.atInfo()).log("stopping client background thread and flushing the report aggregator");
            for (ReportRequest req : this.reportAggregator.clear()) {
                try {
                    this.transport.services().report(this.serviceName, req).execute();
                }
                catch (IOException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a report request failed");
                }
            }
            this.stopped = true;
            if (this.isRunningSchedulerDirectly()) {
                this.resetIfStopped();
            }
            this.scheduler = null;
        }
    }

    @Nullable
    public CheckResponse check(CheckRequest req) {
        this.startIfStopped();
        this.statistics.totalChecks.incrementAndGet();
        Stopwatch w = Stopwatch.createStarted(this.ticker);
        CheckResponse resp = this.checkAggregator.check(req);
        this.statistics.totalCheckCacheLookupTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
        if (resp != null) {
            this.statistics.checkHits.incrementAndGet();
            ((FluentLogger.Api)log.atFiner()).log("using cached check response for %s: %s", (Object)req, (Object)resp);
            return resp;
        }
        try {
            w.reset().start();
            resp = (CheckResponse)this.transport.services().check(this.serviceName, req).execute();
            this.statistics.totalCheckTransportTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            this.checkAggregator.addResponse(req, resp);
            return resp;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a check request %s failed", req);
            return null;
        }
    }

    public AllocateQuotaResponse allocateQuota(AllocateQuotaRequest req) {
        this.startIfStopped();
        this.statistics.totalQuotas.incrementAndGet();
        Stopwatch w = Stopwatch.createStarted(this.ticker);
        AllocateQuotaResponse resp = this.quotaAggregator.allocateQuota(req);
        this.statistics.totalQuotaCacheLookupTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
        if (resp != null) {
            this.statistics.quotaHits.incrementAndGet();
            return resp;
        }
        try {
            w.reset().start();
            resp = (AllocateQuotaResponse)this.transport.services().allocateQuota(this.serviceName, req).execute();
            this.statistics.totalQuotaTransportTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            this.quotaAggregator.cacheResponse(req, resp);
            return resp;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a quota request %s failed", req);
            AllocateQuotaResponse dummyResponse = AllocateQuotaResponse.getDefaultInstance();
            this.quotaAggregator.cacheResponse(req, dummyResponse);
            return dummyResponse;
        }
    }

    public void report(ReportRequest req) {
        this.startIfStopped();
        this.statistics.totalReports.incrementAndGet();
        this.statistics.reportedOperations.addAndGet(req.getOperationsCount());
        Stopwatch w = Stopwatch.createStarted(this.ticker);
        boolean reported = this.reportAggregator.report(req);
        this.statistics.totalReportCacheUpdateTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
        if (!reported) {
            try {
                this.statistics.directReports.incrementAndGet();
                w.reset().start();
                this.transport.services().report(this.serviceName, req).execute();
                this.statistics.totalTransportedReportTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a report request %s failed", req);
            }
        }
        if (this.isRunningSchedulerDirectly()) {
            try {
                this.scheduler.run(false);
            }
            catch (InterruptedException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct run of scheduler failed");
            }
        }
        this.logStatistics();
    }

    private void logStatistics() {
        if (this.statsLogFrequency < 1) {
            return;
        }
        if (this.statistics.totalReports.get() % (long)this.statsLogFrequency == 0L) {
            ((FluentLogger.Api)log.atInfo()).log("stats=%s", this.statistics);
        }
    }

    private void scheduleFlushes() {
        try {
            this.initializeFlushing();
            this.scheduler.run();
            ((FluentLogger.Api)log.atInfo()).log("scheduler %s has no further tasks and will exit", this);
            this.scheduler = null;
        }
        catch (InterruptedException e) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("scheduler %s was interrupted and exited", this);
            this.stopped = true;
        }
        catch (RuntimeException e) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("scheduler %s failed and exited", this);
            this.stopped = true;
        }
    }

    private boolean isRunningSchedulerDirectly() {
        return this.running && this.schedulerThread == null;
    }

    private synchronized void initializeFlushing() {
        ((FluentLogger.Api)log.atInfo()).log("creating a scheduler to control flushing");
        this.scheduler = this.schedulers.create(this.ticker);
        this.scheduler.setStatistics(this.statistics);
        ((FluentLogger.Api)log.atInfo()).log("scheduling the initial check, report, and quota");
        this.flushAndScheduleChecks();
        this.flushAndScheduleReports();
        this.flushAndScheduleQuota();
    }

    private synchronized boolean resetIfStopped() {
        if (!this.stopped) {
            return false;
        }
        this.checkAggregator.clear();
        this.reportAggregator.clear();
        this.quotaAggregator.clear();
        this.running = false;
        return true;
    }

    private void flushAndScheduleChecks() {
        if (this.resetIfStopped()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule check flush: client is stopped");
            return;
        }
        int interval = this.checkAggregator.getFlushIntervalMillis();
        if (interval < 0) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule check flush: caching is disabled");
            return;
        }
        if (this.isRunningSchedulerDirectly()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule check flush: no scheduler thread is running");
            return;
        }
        ((FluentLogger.Api)log.atFine()).log("flushing the check aggregator");
        Stopwatch w = Stopwatch.createUnstarted(this.ticker);
        for (CheckRequest req : this.checkAggregator.flush()) {
            try {
                this.statistics.recachedChecks.incrementAndGet();
                w.reset().start();
                CheckResponse resp = (CheckResponse)this.transport.services().check(this.serviceName, req).execute();
                this.statistics.totalCheckTransportTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
                w.reset().start();
                this.checkAggregator.addResponse(req, resp);
                this.statistics.totalCheckCacheUpdateTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a check request %s failed", req);
            }
        }
        Scheduler currentScheduler = this.scheduler;
        if (this.resetIfStopped()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule succeeding check flush: client is stopped");
            return;
        }
        currentScheduler.enter(new Runnable(){

            @Override
            public void run() {
                Client.this.flushAndScheduleChecks();
            }
        }, interval, 0);
    }

    private void flushAndScheduleReports() {
        if (this.resetIfStopped()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule report flush: client is stopped");
            return;
        }
        int interval = this.reportAggregator.getFlushIntervalMillis();
        if (interval < 0) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule report flush: cache is disabled");
            return;
        }
        ReportRequest[] flushed = this.reportAggregator.flush();
        ((FluentLogger.Api)log.atFine()).log("flushing %d reports from the report aggregator", flushed.length);
        this.statistics.flushedReports.addAndGet(flushed.length);
        Stopwatch w = Stopwatch.createUnstarted(this.ticker);
        for (ReportRequest req : flushed) {
            try {
                this.statistics.flushedOperations.addAndGet(req.getOperationsCount());
                w.reset().start();
                this.transport.services().report(this.serviceName, req).execute();
                this.statistics.totalTransportedReportTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a report request failed");
            }
        }
        if (flushed.length > 0) {
            this.reportStopwatch.reset().start();
        } else if (this.reportStopwatch.elapsed(TimeUnit.SECONDS) > 120L) {
            ((FluentLogger.Api)log.atInfo()).log("Shutting down after no reports in the last %d seconds.", 120);
            this.stop();
            return;
        }
        Scheduler currentScheduler = this.scheduler;
        if (this.resetIfStopped()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule succeeding report flush: client is stopped");
            return;
        }
        currentScheduler.enter(new Runnable(){

            @Override
            public void run() {
                Client.this.flushAndScheduleReports();
            }
        }, interval, 1);
    }

    private void flushAndScheduleQuota() {
        if (this.resetIfStopped()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule quota flush: client is stopped");
            return;
        }
        int interval = this.quotaAggregator.getFlushIntervalMillis();
        if (interval < 0) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule quota flush: caching is disabled");
            return;
        }
        if (this.isRunningSchedulerDirectly()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule check flush: no scheduler thread is running");
            return;
        }
        ((FluentLogger.Api)log.atFine()).log("flushing the quota aggregator");
        Stopwatch w = Stopwatch.createUnstarted(this.ticker);
        List<AllocateQuotaRequest> reqs = this.quotaAggregator.flush();
        ((FluentLogger.Api)log.atFine()).log("flushing %d quota from the quota aggregator", reqs.size());
        for (AllocateQuotaRequest req : reqs) {
            try {
                w.reset().start();
                AllocateQuotaResponse resp = (AllocateQuotaResponse)this.transport.services().allocateQuota(this.serviceName, req).execute();
                this.statistics.totalQuotaTransportTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
                w.reset().start();
                this.quotaAggregator.cacheResponse(req, resp);
                this.statistics.recachedQuotas.incrementAndGet();
                this.statistics.totalQuotaCacheUpdateTimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("direct send of a quota request %s failed", req);
            }
        }
        Scheduler currentScheduler = this.scheduler;
        if (this.resetIfStopped()) {
            ((FluentLogger.Api)log.atFine()).log("did not schedule succeeding quota flush: client is stopped");
            return;
        }
        currentScheduler.enter(new Runnable(){

            @Override
            public void run() {
                Client.this.flushAndScheduleQuota();
            }
        }, interval, 0);
    }

    private static class ScheduledEvent
    implements Comparable<ScheduledEvent> {
        private Runnable scheduledAction;
        private long tickerTime;
        private int priority;

        public ScheduledEvent(Runnable scheduledAction, long tickerTime, int priority) {
            this.scheduledAction = scheduledAction;
            this.tickerTime = tickerTime;
            this.priority = priority;
        }

        public Runnable getScheduledAction() {
            return this.scheduledAction;
        }

        public long getTickerTime() {
            return this.tickerTime;
        }

        @Override
        public int compareTo(ScheduledEvent o) {
            int timeCompare = Long.compare(this.tickerTime, o.tickerTime);
            if (timeCompare != 0) {
                return timeCompare;
            }
            return Long.compare(this.priority, o.priority);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.priority;
            result = 31 * result + (int)(this.tickerTime ^ this.tickerTime >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScheduledEvent other = (ScheduledEvent)obj;
            if (this.tickerTime != other.tickerTime) {
                return false;
            }
            return this.priority == other.priority;
        }
    }

    static class Scheduler {
        private PriorityQueue<ScheduledEvent> queue = Queues.newPriorityQueue();
        private Ticker ticker;
        private Statistics statistics;

        Scheduler(Ticker ticker) {
            this.ticker = ticker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enter(Runnable r, long deltaMillis, int priority) {
            long later = TimeUnit.MILLISECONDS.toNanos(deltaMillis) + this.ticker.read();
            ScheduledEvent event = new ScheduledEvent(r, later, priority);
            Scheduler scheduler = this;
            synchronized (scheduler) {
                this.queue.add(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(boolean block) throws InterruptedException {
            while (!this.queue.isEmpty()) {
                boolean delay = true;
                ScheduledEvent next = null;
                long gap = 0L;
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    next = this.queue.peek();
                    long now = this.ticker.read();
                    gap = next.getTickerTime() - now;
                    if (gap > 0L) {
                        delay = true;
                        next = null;
                    } else {
                        next = (ScheduledEvent)this.queue.remove();
                        delay = false;
                    }
                }
                if (delay) {
                    long gapMillis = TimeUnit.NANOSECONDS.toMillis(gap);
                    if (this.statistics != null) {
                        this.statistics.totalSchedulerSkips.incrementAndGet();
                        this.statistics.totalSchedulerSkiptimeMillis.addAndGet(gapMillis);
                    }
                    if (!block) {
                        ((FluentLogger.Api)log.atFine()).log("Scheduler on %s was not blocking, next event is in %d", (Object)Thread.currentThread(), gapMillis);
                        return;
                    }
                    ((FluentLogger.Api)log.atFine()).log("Scheduler on %s will sleep for %d millis", (Object)Thread.currentThread(), gapMillis);
                    Thread.sleep(gapMillis);
                    continue;
                }
                ((FluentLogger.Api)log.atFine()).log("Scheduler on %s will run an event", Thread.currentThread());
                Stopwatch w = Stopwatch.createStarted(this.ticker);
                next.getScheduledAction().run();
                if (this.statistics == null) continue;
                this.statistics.totalSchedulerRuns.incrementAndGet();
                this.statistics.totalSchedulerRuntimeMillis.addAndGet(w.elapsed(TimeUnit.MILLISECONDS));
            }
        }

        public void run() throws InterruptedException {
            this.run(true);
        }

        public void setStatistics(Statistics statistics) {
            this.statistics = statistics;
        }
    }

    static interface SchedulerFactory {
        public Scheduler create(Ticker var1);
    }

    static class Statistics {
        AtomicLong checkHits = new AtomicLong();
        AtomicLong quotaHits = new AtomicLong();
        AtomicLong directReports = new AtomicLong();
        AtomicLong flushedOperations = new AtomicLong();
        AtomicLong flushedReports = new AtomicLong();
        AtomicLong recachedChecks = new AtomicLong();
        AtomicLong recachedQuotas = new AtomicLong();
        AtomicLong reportedOperations = new AtomicLong();
        AtomicLong totalChecks = new AtomicLong();
        AtomicLong totalReports = new AtomicLong();
        AtomicLong totalQuotas = new AtomicLong();
        AtomicLong totalSchedulerRuns = new AtomicLong();
        AtomicLong totalSchedulerSkips = new AtomicLong();
        AtomicLong totalCheckCacheLookupTimeMillis = new AtomicLong();
        AtomicLong totalCheckCacheUpdateTimeMillis = new AtomicLong();
        AtomicLong totalCheckTransportTimeMillis = new AtomicLong();
        AtomicLong totalTransportedReportTimeMillis = new AtomicLong();
        AtomicLong totalReportCacheUpdateTimeMillis = new AtomicLong();
        AtomicLong totalQuotaCacheLookupTimeMillis = new AtomicLong();
        AtomicLong totalQuotaCacheUpdateTimeMillis = new AtomicLong();
        AtomicLong totalQuotaTransportTimeMillis = new AtomicLong();
        AtomicLong totalSchedulerSkiptimeMillis = new AtomicLong();
        AtomicLong totalSchedulerRuntimeMillis = new AtomicLong();

        Statistics() {
        }

        public double checkHitsPercent() {
            return Statistics.divide(100L * this.checkHits.get(), this.totalChecks.get());
        }

        public double flushedReportsPercent() {
            return Statistics.divide(100L * this.flushedReports.get(), this.totalReports.get());
        }

        public long directChecks() {
            return this.totalChecks.get() - this.checkHits.get();
        }

        public long totalChecksTransported() {
            return this.directChecks() + this.recachedChecks.get();
        }

        public long totalReportsTransported() {
            return this.directReports.get() + this.flushedReports.get();
        }

        public double meanTransportedReportTimeMillis() {
            return Statistics.divide(this.totalTransportedReportTimeMillis.get(), this.totalReportsTransported());
        }

        public double meanReportCacheUpdateTimeMillis() {
            long count = this.totalReports.get() - this.directReports.get();
            return Statistics.divide(this.totalReportCacheUpdateTimeMillis.get(), count);
        }

        public double meanTransportedCheckTimeMillis() {
            return Statistics.divide(this.totalCheckTransportTimeMillis.get(), this.totalChecksTransported());
        }

        public double meanCheckCacheLookupTimeMillis() {
            return Statistics.divide(this.totalCheckCacheLookupTimeMillis, this.totalChecks);
        }

        public double meanCheckCacheUpdateTimeMillis() {
            return Statistics.divide(this.totalCheckCacheUpdateTimeMillis.get(), this.totalChecksTransported());
        }

        private static double divide(AtomicLong dividend, AtomicLong divisor) {
            return Statistics.divide(dividend.get(), divisor.get());
        }

        private static double divide(long dividend, long divisor) {
            if (divisor == 0L) {
                return 0.0;
            }
            return 1.0 * (double)dividend / (double)divisor;
        }

        public String toString() {
            String nl = "\n  ";
            return "statistics:\n  totalChecks:" + this.totalChecks.get() + "\n  " + "checkHits:" + this.checkHits.get() + "\n  " + "checkHitsPercent:" + this.checkHitsPercent() + "\n  " + "recachedChecks:" + this.recachedChecks.get() + "\n  " + "totalChecksTransported:" + this.totalChecksTransported() + "\n  " + "totalTransportedCheckTimeMillis:" + this.totalCheckTransportTimeMillis.get() + "\n  " + "meanTransportedCheckTimeMillis:" + this.meanTransportedCheckTimeMillis() + "\n  " + "totalCheckCacheLookupTimeMillis:" + this.totalCheckCacheLookupTimeMillis.get() + "\n  " + "meanCheckCacheLookupTimeMillis:" + this.meanCheckCacheLookupTimeMillis() + "\n  " + "totalCheckCacheUpdateTimeMillis:" + this.totalCheckCacheUpdateTimeMillis.get() + "\n  " + "meanCheckCacheUpdateTimeMillis:" + this.meanCheckCacheUpdateTimeMillis() + "\n  " + "totalReports:" + this.totalReports.get() + "\n  " + "flushedReports:" + this.flushedReports.get() + "\n  " + "directReports:" + this.directReports.get() + "\n  " + "flushedReportsPercent:" + this.flushedReportsPercent() + "\n  " + "totalReportsTransported:" + this.totalReportsTransported() + "\n  " + "totalTransportedReportTimeMillis:" + this.totalTransportedReportTimeMillis.get() + "\n  " + "meanTransportedReportTimeMillis:" + this.meanTransportedReportTimeMillis() + "\n  " + "totalReportCacheUpdateTimeMillis:" + this.totalReportCacheUpdateTimeMillis.get() + "\n  " + "meanReportCacheUpdateTimeMillis:" + this.meanReportCacheUpdateTimeMillis() + "\n  " + "flushedOperations:" + this.flushedOperations.get() + "\n  " + "reportedOperations:" + this.reportedOperations.get() + "\n  " + "totalSchedulerRuns:" + this.totalSchedulerRuns.get() + "\n  " + "totalSchedulerRuntimeMillis:" + this.totalSchedulerRuntimeMillis.get() + "\n  " + "meanSchedulerRuntimeMillis:" + Statistics.divide(this.totalSchedulerRuntimeMillis, this.totalSchedulerRuns) + "\n  " + "totalSchedulerSkips:" + this.totalSchedulerSkips.get() + "\n  " + "totalSchedulerSkiptimeMillis:" + this.totalSchedulerSkiptimeMillis.get() + "\n  " + "meanSchedulerSkiptimeMillis:" + Statistics.divide(this.totalSchedulerSkiptimeMillis, this.totalSchedulerSkips);
        }
    }

    public static class Builder {
        private int statsLogFrequency;
        private Ticker ticker;
        private HttpTransport transport;
        private ThreadFactory factory;
        private String serviceName;
        private CheckAggregationOptions checkOptions;
        private ReportAggregationOptions reportOptions;
        private QuotaAggregationOptions quotaOptions;
        private SchedulerFactory schedulerFactory = DEFAULT_SCHEDULER_FACTORY;

        public Builder(String name) {
            this.serviceName = name;
        }

        public Builder setTicker(Ticker ticker) {
            this.ticker = ticker;
            return this;
        }

        public Builder setStatsLogFrequency(int frequency) {
            this.statsLogFrequency = frequency;
            return this;
        }

        public Builder setCheckOptions(CheckAggregationOptions options) {
            this.checkOptions = options;
            return this;
        }

        public Builder setReportOptions(ReportAggregationOptions options) {
            this.reportOptions = options;
            return this;
        }

        public Builder setQuotaOptions(QuotaAggregationOptions options) {
            this.quotaOptions = options;
            return this;
        }

        public Builder setHttpTransport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }

        public Builder setFactory(ThreadFactory factory) {
            this.factory = factory;
            return this;
        }

        public Builder setSchedulerFactory(SchedulerFactory f) {
            this.schedulerFactory = f;
            return this;
        }

        public Client build() throws GeneralSecurityException, IOException {
            QuotaAggregationOptions q;
            ReportAggregationOptions r;
            CheckAggregationOptions o;
            ThreadFactory f;
            GoogleCredential c;
            HttpTransport h = this.transport;
            if (h == null) {
                h = GoogleNetHttpTransport.newTrustedTransport();
            }
            if ((c = GoogleCredential.getApplicationDefault(this.transport, new JacksonFactory())).createScopedRequired()) {
                c = c.createScoped(ServiceControlScopes.all());
            }
            if ((f = this.factory) == null) {
                f = new ThreadFactoryBuilder().build();
            }
            if ((o = this.checkOptions) == null) {
                o = new CheckAggregationOptions();
            }
            if ((r = this.reportOptions) == null) {
                r = new ReportAggregationOptions();
            }
            if ((q = this.quotaOptions) == null) {
                q = new QuotaAggregationOptions();
            }
            final GoogleCredential nestedInitializer = c;
            HttpRequestInitializer addUserAgent = new HttpRequestInitializer(){

                @Override
                public void initialize(HttpRequest request) throws IOException {
                    HttpHeaders hdr = new HttpHeaders().setUserAgent("ESP");
                    request.setHeaders(hdr);
                    nestedInitializer.initialize(request);
                }
            };
            return new Client(this.serviceName, o, r, q, new ServiceControl.Builder(h, c).setHttpRequestInitializer(addUserAgent).setApplicationName(Client.CLIENT_APPLICATION_NAME).build(), f, this.schedulerFactory, this.statsLogFrequency, this.ticker);
        }
    }
}

