/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control;

import com.google.api.control.model.MethodRegistry;
import com.google.api.control.model.ReportingRule;
import endpoints.repackaged.com.google.api.Service;
import endpoints.repackaged.com.google.api.config.ServiceConfigException;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfigFilter
implements Filter {
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private static final String ATTRIBUTE_ROOT = ConfigFilter.class.getName();
    @VisibleForTesting
    static final String METHOD_INFO_ATTRIBUTE = ATTRIBUTE_ROOT + ".method_info";
    @VisibleForTesting
    static final String SERVICE_ATTRIBUTE = ATTRIBUTE_ROOT + ".service";
    @VisibleForTesting
    static final String SERVICE_NAME_ATTRIBUTE = ATTRIBUTE_ROOT + ".service_name";
    @VisibleForTesting
    static final String REGISTRY_ATTRIBUTE = ATTRIBUTE_ROOT + ".registry";
    @VisibleForTesting
    static final String REPORTING_ATTRIBUTE = ATTRIBUTE_ROOT + ".reporting";
    @VisibleForTesting
    static final String HTTP_METHOD_OVERRIDE_ATTRIBUTE = ATTRIBUTE_ROOT + ".http_method_override";
    private Service theService;
    private Loader loader;
    private MethodRegistry registry;
    private ReportingRule rule;

    public ConfigFilter(Loader loader) {
        Preconditions.checkNotNull(loader, "The loader must be non-null");
        this.loader = loader;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.theService = this.loader.load();
            this.rule = ReportingRule.fromService(this.theService);
            this.registry = new MethodRegistry(this.theService);
        }
        catch (ServiceConfigException | IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("Failed to load service");
            this.theService = null;
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.theService == null) {
            ((FluentLogger.Api)log.atWarning()).log("Rejecting this API request due to config loading error.");
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(500);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        httpRequest.setAttribute(SERVICE_ATTRIBUTE, this.theService);
        httpRequest.setAttribute(SERVICE_NAME_ATTRIBUTE, this.theService.getName());
        httpRequest.setAttribute(REGISTRY_ATTRIBUTE, this.registry);
        httpRequest.setAttribute(REPORTING_ATTRIBUTE, this.rule);
        ((FluentLogger.Api)log.atFine()).log("Added service %s, and associated attributes to the request", this.theService);
        String uri = httpRequest.getRequestURI();
        String methodOverride = ConfigFilter.getRequestMethodOverride(httpRequest);
        httpRequest.setAttribute(HTTP_METHOD_OVERRIDE_ATTRIBUTE, methodOverride);
        String method = methodOverride != null ? methodOverride : httpRequest.getMethod();
        MethodRegistry.Info info = this.registry.lookup(method, uri);
        if (info != null) {
            httpRequest.setAttribute(METHOD_INFO_ATTRIBUTE, info);
        } else {
            ((FluentLogger.Api)log.atFine()).log("did not add method info to the request");
        }
        chain.doFilter(request, response);
    }

    public static MethodRegistry getRegistry(ServletRequest req) {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        return (MethodRegistry)httpRequest.getAttribute(REGISTRY_ATTRIBUTE);
    }

    public static Service getService(ServletRequest req) {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        return (Service)httpRequest.getAttribute(SERVICE_ATTRIBUTE);
    }

    public static String getServiceName(ServletRequest req) {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        return (String)httpRequest.getAttribute(SERVICE_NAME_ATTRIBUTE);
    }

    public static ReportingRule getReportRule(ServletRequest req) {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        return (ReportingRule)httpRequest.getAttribute(REPORTING_ATTRIBUTE);
    }

    public static MethodRegistry.Info getMethodInfo(ServletRequest req) {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        return (MethodRegistry.Info)httpRequest.getAttribute(METHOD_INFO_ATTRIBUTE);
    }

    public static String getRealHttpMethod(ServletRequest req) {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        String method = (String)httpRequest.getAttribute(HTTP_METHOD_OVERRIDE_ATTRIBUTE);
        if (method != null) {
            return method;
        }
        return httpRequest.getMethod();
    }

    @Override
    public void destroy() {
    }

    @VisibleForTesting
    static String getRequestMethodOverride(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        String methodOverride = null;
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!headerName.toLowerCase().equals("x-http-method-override")) continue;
            methodOverride = request.getHeader(headerName);
            break;
        }
        return methodOverride != null ? methodOverride.toUpperCase() : null;
    }

    public static interface Loader {
        public Service load() throws IOException;
    }
}

