/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control;

import com.google.api.control.Client;
import com.google.api.control.ConfigFilter;
import com.google.api.control.model.CheckErrorInfo;
import com.google.api.control.model.CheckRequestInfo;
import com.google.api.control.model.MethodRegistry;
import com.google.api.control.model.OperationInfo;
import com.google.api.control.model.QuotaErrorInfo;
import com.google.api.control.model.QuotaRequestInfo;
import com.google.api.control.model.ReportRequestInfo;
import com.google.api.control.model.ReportingRule;
import endpoints.repackaged.com.google.api.Service;
import endpoints.repackaged.com.google.api.client.http.GenericUrl;
import endpoints.repackaged.com.google.api.client.http.HttpHeaders;
import endpoints.repackaged.com.google.api.client.http.HttpRequest;
import endpoints.repackaged.com.google.api.client.http.HttpResponse;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.ReportRequest;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Stopwatch;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import endpoints.repackaged.com.google.common.io.CountingOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class ControlFilter
implements Filter {
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private static final String REFERER = "referer";
    private static final String PROJECT_ID_PARAM = "endpoints.projectId";
    private static final String SERVICE_NAME_PARAM = "endpoints.serviceName";
    private static final String STATS_LOG_FREQUENCY_PARAM = "endpoints.statsLogFrequency";
    private static final String DEFAULT_LOCATION = "global";
    private static final List<String> DEFAULT_API_KEYS = ImmutableList.of("key", "api_key");
    private static final String METADATA_SERVER_URL = "http://metadata.google.internal";
    private static final String API_PROXY_EXCEPTION_CLASS_NAME = "com.google.apphosting.api.ApiProxy.ApiProxyException";
    private static final String REMOTE_API_EXCEPTION_CLASS_NAME = "com.google.appengine.tools.remoteapi.RemoteApiException";
    private static final String X_ANDROID_CERT = "x-android-cert";
    private static final String X_ANDROID_PACKAGE = "x-android-package";
    private static final String X_IOS_BUNDLE_ID = "x-ios-bundle-identifier";
    private final Ticker ticker;
    private final Clock clock;
    private final ReportRequestInfo.ReportedPlatforms platform;
    private String projectId;
    private Client client;
    private int statsLogFrequency = -1;
    private Statistics statistics;

    @VisibleForTesting
    public ControlFilter(@Nullable Client client, @Nullable String projectId, @Nullable Ticker ticker, @Nullable Clock clock, @Nullable HttpTransport transport) {
        this.client = client;
        this.setProjectId(projectId);
        this.ticker = ticker == null ? Ticker.systemTicker() : ticker;
        this.clock = clock == null ? Clock.SYSTEM : clock;
        transport = transport == null ? new NetHttpTransport() : transport;
        this.platform = ControlFilter.getPlatformFromEnvironment(System.getenv(), System.getProperties(), transport);
        this.statistics = new Statistics();
    }

    public ControlFilter() {
        this(null, null, null, null, null);
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String configProjectId = filterConfig.getInitParameter(PROJECT_ID_PARAM);
        if (!Strings.isNullOrEmpty(configProjectId)) {
            this.setProjectId(configProjectId);
        }
        String statsFrequencyText = filterConfig.getInitParameter(STATS_LOG_FREQUENCY_PARAM);
        try {
            if (!Strings.isNullOrEmpty(statsFrequencyText)) {
                this.statsLogFrequency = Integer.parseInt(statsFrequencyText);
                ((FluentLogger.Api)log.atWarning()).log("will log stats every %d reports", this.statsLogFrequency);
            }
        }
        catch (NumberFormatException e) {
            ((FluentLogger.Api)log.atWarning()).log("ignored invalid debug stat value %s", statsFrequencyText);
        }
        String configServiceName = filterConfig.getInitParameter(SERVICE_NAME_PARAM);
        if (!Strings.isNullOrEmpty(configServiceName)) {
            try {
                this.client = this.createClient(configServiceName);
                this.client.start();
            }
            catch (GeneralSecurityException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("could not create the control client");
            }
            catch (IOException e) {
                ((FluentLogger.Api)((FluentLogger.Api)log.atSevere()).withCause(e)).log("could not create the control client");
            }
        }
    }

    @Override
    public void destroy() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    protected void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    protected int statsLogFrequency() {
        return this.statsLogFrequency;
    }

    protected Client createClient(String configServiceName) throws GeneralSecurityException, IOException {
        return new Client.Builder(configServiceName).setStatsLogFrequency(this.statsLogFrequency()).setHttpTransport(new NetHttpTransport()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        QuotaRequestInfo quotaInfo;
        CheckErrorInfo errorInfo;
        if (this.client == null) {
            ((FluentLogger.Api)log.atInfo()).log("No control client was created - skipping service control");
            chain.doFilter(request, response);
            return;
        }
        if (this.projectId == null) {
            ((FluentLogger.Api)log.atInfo()).log("No project Id was specified - skipping service control");
            chain.doFilter(request, response);
            return;
        }
        LatencyTimer timer = new LatencyTimer(this.ticker);
        MethodRegistry.Info info = ConfigFilter.getMethodInfo(request);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (info == null) {
            ((FluentLogger.Api)log.atFine()).log("no method corresponds to %s - skipping service control", httpRequest.getRequestURI());
            chain.doFilter(request, response);
            return;
        }
        Stopwatch creationTimer = Stopwatch.createUnstarted(this.ticker);
        Stopwatch overallTimer = Stopwatch.createStarted(this.ticker);
        AppStruct appInfo = new AppStruct();
        appInfo.httpMethod = ConfigFilter.getRealHttpMethod(httpRequest);
        appInfo.requestSize = httpRequest.getContentLength();
        appInfo.url = httpRequest.getRequestURI();
        CheckRequestInfo checkInfo = this.createCheckInfo(httpRequest, appInfo.url, info);
        CheckResponse checkResponse = null;
        long consumerProjectNumber = 0L;
        if (Strings.isNullOrEmpty(checkInfo.getApiKey()) && !info.shouldAllowUnregisteredCalls()) {
            errorInfo = CheckErrorInfo.API_KEY_NOT_PROVIDED;
            ((FluentLogger.Api)log.atFine()).log("no api key was provided");
        } else {
            creationTimer.reset().start();
            CheckRequest checkRequest = checkInfo.asCheckRequest(this.clock);
            this.statistics.totalChecks.incrementAndGet();
            this.statistics.totalCheckCreationTime.addAndGet(creationTimer.elapsed(TimeUnit.MILLISECONDS));
            ((FluentLogger.Api)log.atFine()).log("checking using %s", checkRequest);
            checkResponse = this.client.check(checkRequest);
            errorInfo = CheckErrorInfo.convert(checkResponse);
            if (checkResponse != null) {
                consumerProjectNumber = checkResponse.getCheckInfo().getConsumerInfo().getProjectNumber();
            }
        }
        if (errorInfo != CheckErrorInfo.OK) {
            HttpServletResponse httpResponse;
            ((FluentLogger.Api)log.atWarning()).log("the check did not succeed; the response %s", checkResponse);
            checkInfo.setApiKeyValid(!errorInfo.isApiKeyError());
            appInfo.responseCode = errorInfo.getHttpCode();
            timer.end();
            boolean trickle = false;
            if (errorInfo == CheckErrorInfo.API_KEY_NOT_PROVIDED) {
                httpResponse = (HttpServletResponse)response;
                httpResponse.sendError(errorInfo.getHttpCode(), errorInfo.getMessage());
            } else if (checkResponse == null) {
                trickle = true;
            } else {
                httpResponse = (HttpServletResponse)response;
                httpResponse.sendError(errorInfo.getHttpCode(), errorInfo.fullMessage(this.projectId, checkResponse.getCheckErrors(0).getDetail()));
            }
            if (!trickle) {
                ReportRequest reportRequest = this.createReportRequest(info, checkInfo, appInfo, ConfigFilter.getReportRule(request), timer, consumerProjectNumber);
                ((FluentLogger.Api)log.atFinest()).log("sending an error report request %s", reportRequest);
                this.client.report(reportRequest);
                this.statistics.totalFiltered.incrementAndGet();
                this.statistics.totalFilteredTime.addAndGet(overallTimer.elapsed(TimeUnit.MILLISECONDS));
                this.logStatistics();
                return;
            }
        }
        if ((quotaInfo = this.createQuotaInfo(httpRequest, info)).getMetricCosts().isEmpty()) {
            ((FluentLogger.Api)log.atFine()).log("no metric costs for this method");
        } else {
            AllocateQuotaRequest quotaRequest = quotaInfo.asQuotaRequest(this.clock);
            AllocateQuotaResponse quotaResponse = this.client.allocateQuota(quotaRequest);
            QuotaErrorInfo quotaErrorInfo = QuotaErrorInfo.convert(quotaResponse);
            if (quotaErrorInfo.isReallyError()) {
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.sendError(quotaErrorInfo.getHttpCode(), quotaErrorInfo.getMessage());
                return;
            }
        }
        GenericResponseWrapper wrapper = new GenericResponseWrapper((HttpServletResponse)response);
        try {
            timer.appStart();
            chain.doFilter(request, wrapper);
        }
        finally {
            timer.end();
            response.getOutputStream().close();
        }
        appInfo.responseCode = wrapper.getResponseCode();
        appInfo.responseSize = wrapper.getContentLength() != 0 ? (long)wrapper.getContentLength() : wrapper.getActualContentLength();
        creationTimer.reset().start();
        ReportRequest reportRequest = this.createReportRequest(info, checkInfo, appInfo, ConfigFilter.getReportRule(request), timer, consumerProjectNumber);
        this.statistics.totalReports.incrementAndGet();
        this.statistics.totalReportCreationTime.addAndGet(creationTimer.elapsed(TimeUnit.MILLISECONDS));
        ((FluentLogger.Api)log.atFinest()).log("sending a report request %s", reportRequest);
        this.client.report(reportRequest);
        this.statistics.totalFiltered.incrementAndGet();
        this.statistics.totalFilteredTime.addAndGet(overallTimer.elapsed(TimeUnit.MILLISECONDS));
        this.logStatistics();
    }

    private ReportRequest createReportRequest(MethodRegistry.Info info, CheckRequestInfo checkInfo, AppStruct appInfo, ReportingRule rules, LatencyTimer timer, long consumerProjectNumber) {
        return new ReportRequestInfo(checkInfo).setApiMethod(info.getSelector()).setLocation(DEFAULT_LOCATION).setMethod(appInfo.httpMethod).setOverheadTimeMillis(timer.getOverheadTimeMillis()).setPlatform(this.platform).setProducerProjectId(this.projectId).setProtocol(ReportRequestInfo.ReportedProtocols.HTTP).setRequestSize(appInfo.requestSize).setRequestTimeMillis(timer.getRequestTimeMillis()).setResponseCode(appInfo.responseCode).setResponseSize(appInfo.responseSize).setUrl(appInfo.url).setBackendTimeMillis(timer.getBackendTimeMillis()).setConsumerProjectNumber(consumerProjectNumber).asReportRequest(rules, this.clock);
    }

    private CheckRequestInfo createCheckInfo(HttpServletRequest request, String uri, MethodRegistry.Info info) {
        String serviceName = ConfigFilter.getServiceName(request);
        String apiKey = this.findApiKeyParam(request, info);
        if (Strings.isNullOrEmpty(apiKey)) {
            apiKey = this.findApiKeyHeader(request, info);
        }
        if (Strings.isNullOrEmpty(apiKey)) {
            apiKey = this.findDefaultApiKeyParam(request);
        }
        return new CheckRequestInfo(new OperationInfo().setApiKey(apiKey).setApiKeyValid(!Strings.isNullOrEmpty(apiKey)).setReferer(request.getHeader(REFERER)).setConsumerProjectId(this.projectId).setOperationId(ControlFilter.nextOperationId()).setOperationName(info.getSelector()).setServiceName(serviceName)).setClientIp(request.getRemoteAddr()).setAndroidPackageName(request.getHeader(X_ANDROID_PACKAGE)).setAndroidCertificateFingerprint(request.getHeader(X_ANDROID_CERT)).setIosBundleId(request.getHeader(X_IOS_BUNDLE_ID));
    }

    private QuotaRequestInfo createQuotaInfo(HttpServletRequest request, MethodRegistry.Info info) {
        String serviceName = ConfigFilter.getServiceName(request);
        String apiKey = this.findApiKeyParam(request, info);
        if (Strings.isNullOrEmpty(apiKey)) {
            apiKey = this.findApiKeyHeader(request, info);
        }
        if (Strings.isNullOrEmpty(apiKey)) {
            apiKey = this.findDefaultApiKeyParam(request);
        }
        Service service = ConfigFilter.getService(request);
        return new QuotaRequestInfo(new OperationInfo().setApiKey(apiKey).setApiKeyValid(!Strings.isNullOrEmpty(apiKey)).setReferer(request.getHeader(REFERER)).setConsumerProjectId(this.projectId).setOperationId(ControlFilter.nextOperationId()).setOperationName(info.getSelector()).setServiceName(serviceName)).setMetricCosts(info.getQuotaInfo().getMetricCosts()).setConfigId(service.getId());
    }

    private static String nextOperationId() {
        return UUID.randomUUID().toString();
    }

    private String findApiKeyParam(HttpServletRequest request, MethodRegistry.Info info) {
        List<String> params = info.apiKeyUrlQueryParam();
        if (params.isEmpty()) {
            return "";
        }
        for (String s : params) {
            String value = request.getParameter(s);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    private String findDefaultApiKeyParam(HttpServletRequest request) {
        for (String s : DEFAULT_API_KEYS) {
            String value = request.getParameter(s);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    private String findApiKeyHeader(HttpServletRequest request, MethodRegistry.Info info) {
        List<String> params = info.apiKeyHeaderParam();
        if (params.isEmpty()) {
            return "";
        }
        for (String s : params) {
            String value = request.getHeader(s);
            if (value == null) continue;
            return value;
        }
        return "";
    }

    private void logStatistics() {
        if (this.statsLogFrequency < 1) {
            return;
        }
        if (this.statistics.totalFiltered.get() % (long)this.statsLogFrequency == 0L) {
            ((FluentLogger.Api)log.atInfo()).log("stats=%s", this.statistics);
        }
    }

    @VisibleForTesting
    static ReportRequestInfo.ReportedPlatforms getPlatformFromEnvironment(Map<String, String> env, Properties properties, HttpTransport transport) {
        boolean onGae;
        if (env.containsKey("KUBERNETES_SERVICE_HOST")) {
            return ReportRequestInfo.ReportedPlatforms.GKE;
        }
        boolean hasMetadataServer = ControlFilter.hasMetadataServer(transport);
        String gaeEnvironment = properties.getProperty("com.google.appengine.runtime.environment");
        boolean bl = onGae = gaeEnvironment != null && gaeEnvironment.startsWith("Production");
        if (hasMetadataServer && env.containsKey("GAE_SERVICE")) {
            return ReportRequestInfo.ReportedPlatforms.GAE_FLEX;
        }
        if (hasMetadataServer) {
            return ReportRequestInfo.ReportedPlatforms.GCE;
        }
        if (onGae) {
            return ReportRequestInfo.ReportedPlatforms.GAE_STANDARD;
        }
        if (gaeEnvironment != null && gaeEnvironment.startsWith("Development")) {
            return ReportRequestInfo.ReportedPlatforms.DEVELOPMENT;
        }
        return ReportRequestInfo.ReportedPlatforms.UNKNOWN;
    }

    private static boolean hasMetadataServer(HttpTransport transport) {
        try {
            HttpRequest request = transport.createRequestFactory().buildGetRequest(new GenericUrl(METADATA_SERVER_URL));
            HttpResponse response = request.execute();
            HttpHeaders headers = response.getHeaders();
            return "Google".equals(headers.getFirstHeaderStringValue("Metadata-Flavor"));
        }
        catch (IOException | RuntimeException expected) {
            if (expected instanceof RuntimeException && !API_PROXY_EXCEPTION_CLASS_NAME.equals(expected.getClass().getName()) && !REMOTE_API_EXCEPTION_CLASS_NAME.equals(expected.getClass().getName())) {
                throw (RuntimeException)expected;
            }
            return false;
        }
    }

    private static class GenericResponseWrapper
    extends HttpServletResponseWrapper {
        private CountingOutputStream output;
        private int contentLength;
        private String contentType;
        private int responseCode;
        private FilterServletOutputStream filteredOut;
        private PrintWriter newWriter;

        public GenericResponseWrapper(HttpServletResponse response) throws IOException {
            super(response);
            this.output = new CountingOutputStream(response.getOutputStream());
        }

        public long getActualContentLength() {
            if (this.newWriter != null) {
                this.newWriter.flush();
            }
            return this.output.getCount();
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        @Override
        public ServletOutputStream getOutputStream() {
            if (null == this.filteredOut) {
                this.filteredOut = new FilterServletOutputStream(this.output);
            }
            return this.filteredOut;
        }

        @Override
        public PrintWriter getWriter() {
            if (this.newWriter == null) {
                OutputStreamWriter writer;
                try {
                    writer = new OutputStreamWriter((OutputStream)this.getOutputStream(), this.getCharacterEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    ((FluentLogger.Api)log.atWarning()).log("Could not write using charset %s, using default instead", this.getCharacterEncoding());
                    writer = new OutputStreamWriter(this.getOutputStream());
                }
                this.newWriter = new PrintWriter((Writer)new BufferedWriter(writer), true);
            }
            return this.newWriter;
        }

        @Override
        public void setContentLength(int length) {
            this.contentLength = length;
            super.setContentLength(length);
        }

        public int getContentLength() {
            return this.contentLength;
        }

        @Override
        public void sendError(int sc) throws IOException {
            this.responseCode = sc;
            super.sendError(sc);
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            this.responseCode = sc;
            super.sendError(sc, msg);
        }

        @Override
        public void setContentType(String type) {
            this.contentType = type;
            super.setContentType(type);
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public void setStatus(int sc) {
            this.responseCode = sc;
            super.setStatus(sc);
        }
    }

    static class FilterServletOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }
    }

    private static class LatencyTimer {
        private static final long NOT_STARTED = -1L;
        private final Stopwatch stopwatch;
        private long overheadTimeMillis = -1L;
        private long backendTimeMillis;

        private LatencyTimer(Ticker ticker) {
            this.stopwatch = Stopwatch.createStarted(ticker);
        }

        void appStart() {
            this.overheadTimeMillis = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            this.stopwatch.reset().start();
        }

        void end() {
            this.backendTimeMillis = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (this.overheadTimeMillis == -1L) {
                this.overheadTimeMillis = this.backendTimeMillis;
                this.backendTimeMillis = 0L;
            }
        }

        long getRequestTimeMillis() {
            if (this.overheadTimeMillis == 0L && this.backendTimeMillis == 0L) {
                return -1L;
            }
            return this.overheadTimeMillis + this.backendTimeMillis;
        }

        long getOverheadTimeMillis() {
            return this.overheadTimeMillis > 0L ? this.overheadTimeMillis : -1L;
        }

        long getBackendTimeMillis() {
            return this.backendTimeMillis > 0L ? this.backendTimeMillis : -1L;
        }
    }

    private static class Statistics {
        AtomicLong totalChecks = new AtomicLong();
        AtomicLong totalReports = new AtomicLong();
        AtomicLong totalCheckCreationTime = new AtomicLong();
        AtomicLong totalReportCreationTime = new AtomicLong();
        AtomicLong totalFilteredTime = new AtomicLong();
        AtomicLong totalFiltered = new AtomicLong();

        private Statistics() {
        }

        public String toString() {
            String nl = "\n  ";
            return "filter_statistics:\n  totalFiltered:" + this.totalFiltered.get() + "\n  " + "totalFilteredTime:" + this.totalFilteredTime.get() + "\n  " + "meanFilteredTime:" + Statistics.divide(this.totalFilteredTime, this.totalFiltered) + "\n  " + "totalChecks:" + this.totalChecks.get() + "\n  " + "totalCheckCreationTime:" + this.totalCheckCreationTime.get() + "\n  " + "meanCheckCreationTime:" + Statistics.divide(this.totalCheckCreationTime, this.totalChecks) + "\n  " + "totalReports:" + this.totalReports + "\n  " + "totalReportCreationTime:" + this.totalReportCreationTime.get() + "\n  " + "meanReportCreationTime:" + Statistics.divide(this.totalReportCreationTime, this.totalReports);
        }

        private static double divide(AtomicLong dividend, AtomicLong divisor) {
            if (divisor.get() == 0L) {
                return 0.0;
            }
            return 1.0 * (double)dividend.get() / (double)divisor.get();
        }
    }

    private static class AppStruct {
        String httpMethod;
        long requestSize;
        long responseSize;
        int responseCode = 500;
        String url;

        AppStruct() {
        }
    }
}

