/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import com.google.api.control.aggregator.CheckAggregationOptions;
import com.google.api.control.aggregator.MetricValues;
import com.google.api.control.aggregator.OperationAggregator;
import com.google.api.control.aggregator.Signing;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValue;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValueSet;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.cache.Cache;
import endpoints.repackaged.com.google.common.collect.Lists;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import endpoints.repackaged.com.google.common.hash.HashCode;
import endpoints.repackaged.com.google.common.hash.Hasher;
import endpoints.repackaged.com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;

public class CheckRequestAggregator {
    public static final int NON_CACHING = -1;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final CheckRequest[] NO_REQUESTS = new CheckRequest[0];
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private final String serviceName;
    private final CheckAggregationOptions options;
    private final Map<String, MetricDescriptor.MetricKind> kinds;
    private final ConcurrentLinkedDeque<CachedItem> out;
    private final Cache<String, CachedItem> cache;
    private final Ticker ticker;

    public CheckRequestAggregator(String serviceName, CheckAggregationOptions options, @Nullable Map<String, MetricDescriptor.MetricKind> kinds, @Nullable Ticker ticker) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "service name cannot be empty");
        Preconditions.checkNotNull(options, "options must be non-null");
        this.out = new ConcurrentLinkedDeque();
        this.ticker = ticker == null ? Ticker.systemTicker() : ticker;
        this.cache = options.createCache(this.out, this.ticker);
        this.serviceName = serviceName;
        this.options = options;
        this.kinds = kinds;
    }

    public CheckRequestAggregator(String serviceName, CheckAggregationOptions options, @Nullable Map<String, MetricDescriptor.MetricKind> kinds) {
        this(serviceName, options, kinds, Ticker.systemTicker());
    }

    public CheckRequestAggregator(String serviceName, CheckAggregationOptions options) {
        this(serviceName, options, null);
    }

    public int getFlushIntervalMillis() {
        if (this.cache == null) {
            return -1;
        }
        return this.options.getExpirationMillis();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.cache == null) {
            return;
        }
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            this.cache.invalidateAll();
            this.out.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckRequest[] flush() {
        if (this.cache == null) {
            return NO_REQUESTS;
        }
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            this.cache.cleanUp();
            ArrayList<CheckRequest> reqs = Lists.newArrayList();
            for (CachedItem item : this.out) {
                CheckRequest req = item.extractRequest();
                if (req == null) continue;
                reqs.add(req);
            }
            this.out.clear();
            return reqs.toArray(new CheckRequest[reqs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResponse(CheckRequest req, CheckResponse resp) {
        if (this.cache == null) {
            return;
        }
        String signature = CheckRequestAggregator.sign(req).toString();
        long now = this.ticker.read();
        int quotaScale = 0;
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            CachedItem item = this.cache.getIfPresent(signature);
            if (item == null) {
                this.cache.put(signature, new CachedItem(resp, req, this.kinds, now, quotaScale));
            } else {
                item.lastCheckTimestamp = now;
                item.response = resp;
                item.quotaScale = quotaScale;
                item.isFlushing = false;
                this.cache.put(signature, item);
            }
        }
    }

    @Nullable
    public CheckResponse check(CheckRequest req) {
        if (this.cache == null) {
            return null;
        }
        Preconditions.checkArgument(req.getServiceName().equals(this.serviceName), String.format("service name mismatch. Aggregator service '%s', request service '%s'", this.serviceName, req.getServiceName()));
        Preconditions.checkNotNull(req.getOperation(), "expected check operation was not present");
        if (req.getOperation().getImportance() != Operation.Importance.LOW) {
            return null;
        }
        String signature = CheckRequestAggregator.sign(req).toString();
        CachedItem item = this.cache.getIfPresent(signature);
        if (item == null) {
            return null;
        }
        return this.handleCachedResponse(req, item);
    }

    private boolean isCurrent(CachedItem item) {
        long age = this.ticker.read() - item.lastCheckTimestamp;
        return age < (long)(this.options.getFlushCacheEntryIntervalMillis() * 1000000);
    }

    private CheckResponse handleCachedResponse(CheckRequest req, CachedItem item) {
        if (item.response.getCheckErrorsCount() > 0) {
            if (this.isCurrent(item)) {
                return item.response;
            }
            item.lastCheckTimestamp = this.ticker.read();
            return null;
        }
        if (this.isCurrent(item)) {
            return item.response;
        }
        item.updateRequest(req, this.kinds);
        if (item.isFlushing) {
            ((FluentLogger.Api)log.atWarning()).log("latest check request has not completed");
        }
        item.isFlushing = true;
        item.lastCheckTimestamp = this.ticker.read();
        return null;
    }

    public static HashCode sign(CheckRequest value) {
        Hasher h = Hashing.md5().newHasher();
        Operation o = value.getOperation();
        if (o == null || Strings.isNullOrEmpty(o.getConsumerId()) || Strings.isNullOrEmpty(o.getOperationName())) {
            throw new IllegalArgumentException("CheckRequest should have a valid operation");
        }
        h.putString(o.getConsumerId(), StandardCharsets.UTF_8);
        h.putChar('\u0000');
        h.putString(o.getOperationName(), StandardCharsets.UTF_8);
        h.putChar('\u0000');
        Signing.putLabels(h, o.getLabels());
        for (MetricValueSet mvSet : o.getMetricValueSetsList()) {
            h.putString(mvSet.getMetricName(), StandardCharsets.UTF_8);
            h.putChar('\u0000');
            for (MetricValue metricValue : mvSet.getMetricValuesList()) {
                MetricValues.putMetricValue(h, metricValue);
            }
        }
        return h.hash();
    }

    private static class CachedItem {
        boolean isFlushing;
        long lastCheckTimestamp;
        int quotaScale;
        CheckResponse response;
        private final String serviceName;
        private OperationAggregator aggregator;

        CachedItem(CheckResponse response, CheckRequest request, Map<String, MetricDescriptor.MetricKind> kinds, long lastCheckTimestamp, int quotaScale) {
            this.response = response;
            this.serviceName = request.getServiceName();
            this.lastCheckTimestamp = lastCheckTimestamp;
            this.quotaScale = quotaScale;
            this.aggregator = new OperationAggregator(request.getOperation(), kinds);
        }

        public synchronized void updateRequest(CheckRequest req, Map<String, MetricDescriptor.MetricKind> kinds) {
            if (this.aggregator == null) {
                this.aggregator = new OperationAggregator(req.getOperation(), kinds);
            } else {
                this.aggregator.add(req.getOperation());
            }
        }

        public synchronized CheckRequest extractRequest() {
            if (this.aggregator == null) {
                return null;
            }
            Operation op = this.aggregator.asOperation();
            this.aggregator = null;
            return CheckRequest.newBuilder().setServiceName(this.serviceName).setOperation(op).build();
        }
    }
}

