/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import com.google.api.control.aggregator.Signing;
import com.google.api.control.model.Distributions;
import com.google.api.control.model.Timestamps;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValue;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import endpoints.repackaged.com.google.common.hash.HashCode;
import endpoints.repackaged.com.google.common.hash.Hasher;
import endpoints.repackaged.com.google.common.hash.Hashing;

public final class MetricValues {
    private static final String MSG_NOT_MERGABLE = "Metric type not mergeabe";
    private static final String MSG_CANNOT_MERGE_DIFFERENT_TYPES = "Cannot merge metrics with different types of value";
    private static final FluentLogger log = FluentLogger.forEnclosingClass();

    private MetricValues() {
    }

    public static Hasher putMetricValue(Hasher h, MetricValue value) {
        Signing.putLabels(h, value.getLabelsMap());
        return h;
    }

    public static HashCode sign(MetricValue value) {
        Hasher h = Hashing.md5().newHasher();
        return MetricValues.putMetricValue(h, value).hash();
    }

    public static MetricValue merge(MetricDescriptor.MetricKind kind, MetricValue prior, MetricValue latest) {
        if (prior.getValueCase() != latest.getValueCase()) {
            ((FluentLogger.Api)log.atWarning()).log("Could not merge different types of metric: %s, %s", (Object)prior, (Object)latest);
            throw new IllegalArgumentException(MSG_CANNOT_MERGE_DIFFERENT_TYPES);
        }
        if (kind == MetricDescriptor.MetricKind.DELTA) {
            MetricValue.Builder builder = latest.toBuilder();
            MetricValues.mergeTimestamps(builder, prior, latest);
            MetricValues.mergeValues(builder, prior, latest);
            return builder.build();
        }
        if (Timestamps.COMPARATOR.compare(prior.getEndTime(), latest.getEndTime()) < 0) {
            return latest;
        }
        return prior;
    }

    static void mergeValues(MetricValue.Builder builder, MetricValue prior, MetricValue latest) {
        switch (latest.getValueCase()) {
            case DOUBLE_VALUE: {
                builder.setDoubleValue(prior.getDoubleValue() + latest.getDoubleValue());
                break;
            }
            case DISTRIBUTION_VALUE: {
                builder.setDistributionValue(Distributions.merge(prior.getDistributionValue(), latest.getDistributionValue()));
                break;
            }
            case INT64_VALUE: {
                builder.setInt64Value(prior.getInt64Value() + latest.getInt64Value());
                break;
            }
            default: {
                ((FluentLogger.Api)log.atWarning()).log("Could not merge logs with unmergable metric types: %s, %s", (Object)prior, (Object)latest);
                throw new IllegalArgumentException(MSG_NOT_MERGABLE);
            }
        }
    }

    private static void mergeTimestamps(MetricValue.Builder builder, MetricValue prior, MetricValue latest) {
        if (Timestamps.COMPARATOR.compare(prior.getEndTime(), latest.getEndTime()) > 0) {
            builder.setEndTime(prior.getEndTime());
        }
        if (Timestamps.COMPARATOR.compare(prior.getStartTime(), latest.getStartTime()) < 0) {
            builder.setStartTime(prior.getStartTime());
        }
    }
}

