/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import com.google.api.control.aggregator.MetricValues;
import com.google.api.control.model.Timestamps;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValue;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValueSet;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class OperationAggregator {
    public static final MetricDescriptor.MetricKind DEFAULT_KIND = MetricDescriptor.MetricKind.DELTA;
    private final Operation.Builder op;
    private final Map<String, MetricDescriptor.MetricKind> kinds;
    private final Map<String, Map<String, MetricValue>> metricValues;

    public OperationAggregator(Operation op, Map<String, MetricDescriptor.MetricKind> kinds) {
        this.kinds = kinds != null ? ImmutableMap.copyOf(kinds) : ImmutableMap.of();
        this.op = op.toBuilder().clearMetricValueSets();
        this.metricValues = Maps.newHashMap();
        this.mergeMetricValues(op);
    }

    public void add(Operation other) {
        this.op.addAllLogEntries(other.getLogEntriesList());
        this.mergeMetricValues(other);
        this.mergeTimestamps(other);
    }

    public Operation asOperation() {
        this.op.clearMetricValueSets();
        TreeSet<String> keySet = Sets.newTreeSet(this.metricValues.keySet());
        for (String name : keySet) {
            Collection<MetricValue> values = this.metricValues.get(name).values();
            this.op.addMetricValueSets(MetricValueSet.newBuilder().setMetricName(name).addAllMetricValues(values));
        }
        return this.op.build();
    }

    private void mergeMetricValues(Operation other) {
        List<MetricValueSet> mvSets = other.getMetricValueSetsList();
        for (MetricValueSet mvSet : mvSets) {
            Map<String, MetricValue> bySignature = this.metricValues.get(mvSet.getMetricName());
            if (bySignature == null) {
                bySignature = Maps.newHashMap();
                this.metricValues.put(mvSet.getMetricName(), bySignature);
            }
            for (MetricValue mv : mvSet.getMetricValuesList()) {
                String signature = MetricValues.sign(mv).toString();
                MetricValue prior = bySignature.get(signature);
                if (prior == null) {
                    bySignature.put(signature, mv);
                    continue;
                }
                MetricDescriptor.MetricKind kind = this.kinds.get(mvSet.getMetricName());
                if (kind == null) {
                    kind = DEFAULT_KIND;
                }
                bySignature.put(signature, MetricValues.merge(kind, prior, mv));
            }
        }
    }

    private void mergeTimestamps(Operation other) {
        if (Timestamps.COMPARATOR.compare(other.getStartTime(), this.op.getStartTime()) == -1) {
            this.op.setStartTime(other.getStartTime());
        }
        if (Timestamps.COMPARATOR.compare(this.op.getEndTime(), other.getEndTime()) == -1) {
            this.op.setEndTime(other.getEndTime());
        }
    }
}

