/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import com.google.api.control.aggregator.MetricValues;
import com.google.api.control.model.Timestamps;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValue;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValueSet;
import endpoints.repackaged.com.google.api.servicecontrol.v1.QuotaOperation;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import java.util.Map;

public class QuotaOperationAggregator {
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private QuotaOperation.Builder op;
    private Map<String, MetricValue> metricValueSets;

    public QuotaOperationAggregator(QuotaOperation op) {
        this.op = op.toBuilder().clearQuotaMetrics();
        this.metricValueSets = Maps.newHashMap();
        this.mergeOperation(op);
    }

    public void mergeOperation(QuotaOperation op) {
        for (MetricValueSet mvSet : op.getQuotaMetricsList()) {
            MetricValue val = this.metricValueSets.get(mvSet.getMetricName());
            if (val == null) {
                this.metricValueSets.put(mvSet.getMetricName(), mvSet.getMetricValues(0));
                continue;
            }
            this.metricValueSets.put(mvSet.getMetricName(), MetricValues.merge(MetricDescriptor.MetricKind.DELTA, val, mvSet.getMetricValues(0)));
        }
    }

    public QuotaOperation asQuotaOperation() {
        QuotaOperation.Builder op = this.op.clone().clearQuotaMetrics();
        for (Map.Entry<String, MetricValue> entry : this.metricValueSets.entrySet()) {
            op.addQuotaMetrics(MetricValueSet.newBuilder().setMetricName(entry.getKey()).addMetricValues(entry.getValue()));
        }
        return op.build();
    }

    private MetricValue mergeDeltaMetricValue(MetricValue from, MetricValue to) {
        if (to.getValueCase() != from.getValueCase()) {
            ((FluentLogger.Api)log.atWarning()).log("Could not merge different types of metric: %s, %s", (Object)from, (Object)to);
            return to;
        }
        MetricValue.Builder builder = to.toBuilder();
        if (from.hasStartTime() && (!to.hasStartTime() || Timestamps.COMPARATOR.compare(from.getStartTime(), to.getStartTime()) == -1)) {
            builder.setStartTime(from.getStartTime());
        }
        if (from.hasEndTime() && (!to.hasEndTime() || Timestamps.COMPARATOR.compare(to.getEndTime(), from.getEndTime()) == -1)) {
            builder.setEndTime(from.getEndTime());
        }
        MetricValues.mergeValues(builder, to, from);
        switch (to.getValueCase()) {
            case INT64_VALUE: {
                builder.setInt64Value(to.getInt64Value() + from.getInt64Value());
                break;
            }
            default: {
                ((FluentLogger.Api)log.atWarning()).log("Unknown metric kind for: %s", from);
            }
        }
        return builder.build();
    }
}

