/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import com.google.api.control.aggregator.QuotaAggregationOptions;
import com.google.api.control.aggregator.QuotaOperationAggregator;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValueSet;
import endpoints.repackaged.com.google.api.servicecontrol.v1.QuotaOperation;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.cache.Cache;
import endpoints.repackaged.com.google.common.cache.CacheBuilder;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.ImmutableSortedSet;
import endpoints.repackaged.com.google.common.collect.Ordering;
import endpoints.repackaged.com.google.common.hash.HashCode;
import endpoints.repackaged.com.google.common.hash.Hasher;
import endpoints.repackaged.com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class QuotaRequestAggregator {
    public static final int NON_CACHING = -1;
    private static final long NANOS_PER_MILLI = 1000000L;
    private final ConcurrentLinkedDeque<AllocateQuotaRequest> out;
    private final String serviceName;
    private final Ticker ticker;
    private final Cache<String, CachedItem> cache;
    private final QuotaAggregationOptions options;
    private final long timeoutIntervalNs;
    private boolean inFlushAll;

    public QuotaRequestAggregator(String serviceName, QuotaAggregationOptions options, @Nullable Ticker ticker) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "service name cannot be empty");
        Preconditions.checkNotNull(options, "options must be non-null");
        this.out = new ConcurrentLinkedDeque();
        this.ticker = ticker == null ? Ticker.systemTicker() : ticker;
        this.serviceName = serviceName;
        this.options = options;
        this.cache = this.createCache(this.ticker);
        this.timeoutIntervalNs = (long)options.getTimeoutMillis() * 1000000L;
    }

    public int getFlushIntervalMillis() {
        if (this.cache == null) {
            return -1;
        }
        return this.options.getRefreshMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AllocateQuotaRequest> flush() {
        if (this.cache == null) {
            return ImmutableList.of();
        }
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            this.cache.cleanUp();
            for (Map.Entry entry : this.cache.asMap().entrySet()) {
                CachedItem item = (CachedItem)entry.getValue();
                if (this.inFlushAll || this.shouldDrop(item) || item.isInFlight || item.aggregator == null) continue;
                item.isInFlight = true;
                item.lastRefreshTimestamp = this.ticker.read();
                this.out.add(item.extractRequest());
            }
            ArrayList<AllocateQuotaRequest> reqs = new ArrayList<AllocateQuotaRequest>(this.out);
            this.out.clear();
            return reqs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.cache == null) {
            return;
        }
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            this.inFlushAll = true;
            this.cache.invalidateAll();
            this.out.clear();
            this.inFlushAll = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateQuotaResponse allocateQuota(AllocateQuotaRequest req) {
        Preconditions.checkArgument(req.getServiceName().equals(this.serviceName), String.format("service name mismatch. Aggregator service '%s', request service '%s'", this.serviceName, req.getServiceName()));
        Preconditions.checkArgument(req.hasAllocateOperation(), "expected quota operation was not present");
        if (this.cache == null) {
            return null;
        }
        String signature = QuotaRequestAggregator.sign(req).toString();
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            CachedItem item = this.cache.getIfPresent(signature);
            if (item == null) {
                AllocateQuotaResponse tempResponse = AllocateQuotaResponse.getDefaultInstance();
                item = new CachedItem(req, tempResponse, this.ticker.read());
                item.signature = signature;
                item.isInFlight = true;
                this.cache.put(signature, item);
                this.out.add(req);
                return tempResponse;
            }
            if (!item.isInFlight && this.shouldRefresh(item)) {
                item.isInFlight = true;
                item.lastRefreshTimestamp = this.ticker.read();
                AllocateQuotaRequest refreshRequest = item.extractRequest();
                if (!item.isPositiveResponse()) {
                    QuotaOperation allocateOp = refreshRequest.getAllocateOperation();
                    refreshRequest.toBuilder().setAllocateOperation(allocateOp.toBuilder().setQuotaMode(QuotaOperation.QuotaMode.NORMAL)).build();
                }
                this.out.add(refreshRequest);
            }
            if (item.isPositiveResponse()) {
                item.aggregate(req);
            }
            return item.response;
        }
    }

    private boolean shouldRefresh(CachedItem item) {
        return this.ticker.read() - item.lastRefreshTimestamp >= (long)this.options.getRefreshMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheResponse(AllocateQuotaRequest req, AllocateQuotaResponse resp) {
        if (this.cache == null) {
            return;
        }
        String signature = QuotaRequestAggregator.sign(req).toString();
        Cache<String, CachedItem> cache = this.cache;
        synchronized (cache) {
            CachedItem item = this.cache.getIfPresent(signature);
            if (item != null) {
                item.isInFlight = false;
                item.response = resp;
            }
        }
    }

    @VisibleForTesting
    static HashCode sign(AllocateQuotaRequest req) {
        Hasher h = Hashing.md5().newHasher();
        QuotaOperation o = req.getAllocateOperation();
        h.putString(o.getMethodName(), StandardCharsets.UTF_8);
        h.putChar('\u0000');
        h.putString(o.getConsumerId(), StandardCharsets.UTF_8);
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(Ordering.natural());
        for (MetricValueSet mvSet : o.getQuotaMetricsList()) {
            builder.add(mvSet.getMetricName());
        }
        for (String metricName : builder.build()) {
            h.putChar('\u0000');
            h.putString(metricName, StandardCharsets.UTF_8);
        }
        return h.hash();
    }

    @Nullable
    private Cache<String, CachedItem> createCache(Ticker ticker) {
        Preconditions.checkNotNull(ticker, "The ticker cannot be null");
        if (this.options.getNumEntries() <= 0) {
            return null;
        }
        CacheBuilder<Object, Object> b = CacheBuilder.newBuilder().maximumSize(this.options.getNumEntries()).ticker(ticker);
        b.expireAfterWrite(this.options.getTimeoutMillis(), TimeUnit.MILLISECONDS);
        return b.build();
    }

    private boolean shouldDrop(CachedItem item) {
        long age = this.ticker.read() - item.lastRefreshTimestamp;
        return age >= this.timeoutIntervalNs;
    }

    private static class CachedItem {
        private boolean isInFlight = false;
        private long lastRefreshTimestamp;
        private AllocateQuotaRequest request;
        private AllocateQuotaResponse response;
        private final String serviceName;
        private QuotaOperationAggregator aggregator;
        private String signature;

        CachedItem(AllocateQuotaRequest req, AllocateQuotaResponse resp, long lastRefreshTimestamp) {
            this.request = req;
            this.response = resp;
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            this.serviceName = this.request.getServiceName();
        }

        synchronized void aggregate(AllocateQuotaRequest req) {
            if (this.aggregator == null) {
                this.aggregator = new QuotaOperationAggregator(req.getAllocateOperation());
            } else {
                this.aggregator.mergeOperation(req.getAllocateOperation());
            }
        }

        synchronized AllocateQuotaRequest extractRequest() {
            if (this.aggregator == null) {
                return this.request;
            }
            QuotaOperation op = this.aggregator.asQuotaOperation();
            this.aggregator = null;
            return AllocateQuotaRequest.newBuilder().setServiceName(this.serviceName).setAllocateOperation(op).build();
        }

        synchronized void clearAllocationErrors() {
            this.response = this.response.toBuilder().clearAllocateErrors().build();
        }

        synchronized void setQuotaResponse(AllocateQuotaResponse response) {
            this.response = response;
            if (response.getAllocateErrorsCount() > 0) {
                this.aggregator = null;
            }
        }

        boolean isPositiveResponse() {
            return this.response.getAllocateErrorsCount() == 0;
        }
    }
}

