/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.cache.Cache;
import endpoints.repackaged.com.google.common.cache.CacheBuilder;
import endpoints.repackaged.com.google.common.cache.RemovalListener;
import endpoints.repackaged.com.google.common.cache.RemovalNotification;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ReportAggregationOptions {
    public static final int DEFAULT_NUM_ENTRIES = 1000;
    public static final int DEFAULT_FLUSH_CACHE_ENTRY_INTERVAL_MILLIS = 4000;
    private final int numEntries;
    private final int flushCacheEntryIntervalMillis;

    public ReportAggregationOptions(int numEntries, int flushCacheEntryIntervalMillis) {
        this.numEntries = numEntries;
        this.flushCacheEntryIntervalMillis = flushCacheEntryIntervalMillis;
    }

    public ReportAggregationOptions() {
        this(1000, 4000);
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public int getFlushCacheEntryIntervalMillis() {
        return this.flushCacheEntryIntervalMillis;
    }

    @Nullable
    public <T> Cache<String, T> createCache(ConcurrentLinkedDeque<T> out) {
        return this.createCache(out, Ticker.systemTicker());
    }

    @Nullable
    public <T> Cache<String, T> createCache(final ConcurrentLinkedDeque<T> out, Ticker ticker) {
        Preconditions.checkNotNull(out, "The out deque cannot be null");
        Preconditions.checkNotNull(ticker, "The ticker cannot be null");
        if (this.numEntries <= 0) {
            return null;
        }
        RemovalListener listener = new RemovalListener<String, T>(){

            @Override
            public void onRemoval(RemovalNotification<String, T> notification) {
                out.addFirst(notification.getValue());
            }
        };
        CacheBuilder b = CacheBuilder.newBuilder().maximumSize(this.numEntries).ticker(ticker).removalListener(listener);
        if (this.flushCacheEntryIntervalMillis >= 0) {
            b.expireAfterWrite(this.flushCacheEntryIntervalMillis, TimeUnit.MILLISECONDS);
        }
        return b.build();
    }
}

