/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.aggregator;

import com.google.api.control.aggregator.OperationAggregator;
import com.google.api.control.aggregator.ReportAggregationOptions;
import com.google.api.control.aggregator.Signing;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.api.servicecontrol.v1.ReportRequest;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.base.Ticker;
import endpoints.repackaged.com.google.common.cache.Cache;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.collect.Lists;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.hash.HashCode;
import endpoints.repackaged.com.google.common.hash.Hasher;
import endpoints.repackaged.com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;

public class ReportRequestAggregator {
    public static final int NON_CACHING = -1;
    public static final int MAX_OPERATION_COUNT = 1000;
    private static final ReportRequest[] NO_REQUESTS = new ReportRequest[0];
    private final Cache<String, OperationAggregator> cache;
    private final Map<String, MetricDescriptor.MetricKind> kinds;
    private final ConcurrentLinkedDeque<OperationAggregator> out;
    private final ReportAggregationOptions options;
    private final String serviceName;

    public ReportRequestAggregator(String serviceName, ReportAggregationOptions options, @Nullable Map<String, MetricDescriptor.MetricKind> kinds, @Nullable Ticker ticker) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "service name cannot be empty");
        Preconditions.checkNotNull(options, "options must be non-null");
        this.kinds = kinds == null ? ImmutableMap.of() : ImmutableMap.copyOf(kinds);
        this.serviceName = serviceName;
        this.out = new ConcurrentLinkedDeque();
        this.cache = options.createCache(this.out, ticker == null ? Ticker.systemTicker() : ticker);
        this.options = options;
    }

    public ReportRequestAggregator(String serviceName, ReportAggregationOptions options, @Nullable Map<String, MetricDescriptor.MetricKind> kinds) {
        this(serviceName, options, kinds, Ticker.systemTicker());
    }

    public ReportRequestAggregator(String serviceName, ReportAggregationOptions options) {
        this(serviceName, options, ImmutableMap.of());
    }

    public int getFlushIntervalMillis() {
        if (this.cache == null) {
            return -1;
        }
        return this.options.getFlushCacheEntryIntervalMillis();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportRequest[] clear() {
        if (this.cache == null) {
            return NO_REQUESTS;
        }
        Cache<String, OperationAggregator> cache = this.cache;
        synchronized (cache) {
            ReportRequest[] res = this.generatedFlushRequests(this.cache.asMap().values());
            this.cache.invalidateAll();
            this.out.clear();
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportRequest[] flush() {
        if (this.cache == null) {
            return NO_REQUESTS;
        }
        Cache<String, OperationAggregator> cache = this.cache;
        synchronized (cache) {
            this.cache.cleanUp();
            ReportRequest[] res = this.generatedFlushRequests(this.out);
            this.out.clear();
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean report(ReportRequest req) {
        if (this.cache == null) {
            return false;
        }
        Preconditions.checkArgument(req.getServiceName().equals(this.serviceName), String.format("service name mismatch. Aggregator service '%s', request service '%s'", this.serviceName, req.getServiceName()));
        if (ReportRequestAggregator.hasHighImportanceOperation(req)) {
            return false;
        }
        Map<String, Operation> bySignature = ReportRequestAggregator.opsBySignature(req);
        Cache<String, OperationAggregator> cache = this.cache;
        synchronized (cache) {
            for (Map.Entry<String, Operation> entry : bySignature.entrySet()) {
                String signature = entry.getKey();
                OperationAggregator agg = this.cache.getIfPresent(signature);
                if (agg == null) {
                    this.cache.put(signature, new OperationAggregator(entry.getValue(), this.kinds));
                    continue;
                }
                agg.add(entry.getValue());
            }
        }
        return true;
    }

    protected ReportRequest[] generatedFlushRequests(Iterable<OperationAggregator> aggregators) {
        ArrayList<ReportRequest> reqs = Lists.newArrayList();
        ReportRequest.Builder current = ReportRequest.newBuilder().setServiceName(this.serviceName);
        for (OperationAggregator agg : aggregators) {
            if (current.getOperationsCount() == 1000) {
                reqs.add(current.build());
                current.clearOperations();
            }
            current.addOperations(agg.asOperation());
        }
        if (current.getOperationsCount() > 0) {
            reqs.add(current.build());
        }
        return reqs.toArray(new ReportRequest[0]);
    }

    private static HashCode sign(Operation value) {
        Hasher h = Hashing.md5().newHasher();
        h.putString(value.getConsumerId(), StandardCharsets.UTF_8);
        h.putChar('\u0000');
        h.putString(value.getOperationName(), StandardCharsets.UTF_8);
        h.putChar('\u0000');
        return Signing.putLabels(h, value.getLabels()).hash();
    }

    private static Map<String, Operation> opsBySignature(ReportRequest req) {
        HashMap<String, Operation> result = Maps.newHashMap();
        for (Operation op : req.getOperationsList()) {
            result.put(ReportRequestAggregator.sign(op).toString(), op);
        }
        return result;
    }

    private static boolean hasHighImportanceOperation(ReportRequest req) {
        for (Operation operation : req.getOperationsList()) {
            if (operation.getImportance() != Operation.Importance.HIGH) continue;
            return true;
        }
        return false;
    }
}

