/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckError;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckResponse;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public enum CheckErrorInfo {
    OK(CheckError.Code.UNRECOGNIZED, 200, "", false),
    NAMESPACE_LOOKUP_UNAVAILABLE(CheckError.Code.NAMESPACE_LOOKUP_UNAVAILABLE, 200, "", false),
    SERVICE_STATUS_UNAVAILABLE(CheckError.Code.SERVICE_STATUS_UNAVAILABLE, 200, "", false),
    BILLING_STATUS_UNAVAILABLE(CheckError.Code.BILLING_STATUS_UNAVAILABLE, 200, "", false),
    NOT_FOUND(CheckError.Code.NOT_FOUND, 400, "Client project not found. Please pass a valid project", false),
    API_KEY_NOT_FOUND(CheckError.Code.API_KEY_NOT_FOUND, 400, "API key not found. Please pass a valid API key", true),
    API_KEY_EXPIRED(CheckError.Code.API_KEY_EXPIRED, 400, "API key expired.  Please renew the API key", true),
    API_KEY_INVALID(CheckError.Code.API_KEY_INVALID, 400, "API key not valid. Please pass a valid API key", true),
    SERVICE_NOT_ACTIVATED(CheckError.Code.SERVICE_NOT_ACTIVATED, 403, "{detail} Please enable the project for {project_id}", false),
    PERMISSION_DENIED(CheckError.Code.PERMISSION_DENIED, 403, "Permission denied: {detail}", false),
    IP_ADDRESS_BLOCKED(CheckError.Code.IP_ADDRESS_BLOCKED, 403, "{detail}", false),
    REFERER_BLOCKED(CheckError.Code.CLIENT_APP_BLOCKED, 403, "{detail}", false),
    CLIENT_APP_BLOCKED(CheckError.Code.CLIENT_APP_BLOCKED, 403, "{detail}", false),
    PROJECT_DELETED(CheckError.Code.PROJECT_DELETED, 403, "Project {project_id} has been deleted", false),
    PROJECT_INVALID(CheckError.Code.PROJECT_INVALID, 400, "Client Project is not valid.  Please pass a valid project", false),
    BILLING_DISABLED(CheckError.Code.BILLING_DISABLED, 400, "Project {project_id} has billing disabled. Please enable it", false),
    UNKNOWN(CheckError.Code.UNRECOGNIZED, 500, "Request blocked due to unsupported block reason {detail}", false),
    API_KEY_NOT_PROVIDED(CheckError.Code.UNRECOGNIZED, 401, "Method doesn't allow callers without established identity. Please use an API key or other form of API consumer identity to call this API.", true);

    private final CheckError.Code code;
    private final int httpCode;
    private final String message;
    private final boolean isApiKeyError;
    private static final Map<CheckError.Code, CheckErrorInfo> CONVERSION;

    private CheckErrorInfo(CheckError.Code code, int httpCode, String message, boolean isApiKeyError) {
        this.code = code;
        this.httpCode = httpCode;
        this.message = message;
        this.isApiKeyError = isApiKeyError;
    }

    public String fullMessage(@Nullable String projectId, @Nullable String detail) {
        projectId = Strings.nullToEmpty(projectId);
        detail = Strings.nullToEmpty(detail);
        return this.message.replaceAll("\\{project_id\\}", projectId).replaceAll("\\{detail\\}", detail);
    }

    public String getMessage() {
        return this.message;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public boolean isApiKeyError() {
        return this.isApiKeyError;
    }

    public static final CheckErrorInfo convert(@Nullable CheckResponse response) {
        if (response == null) {
            return SERVICE_STATUS_UNAVAILABLE;
        }
        if (response.getCheckErrorsCount() == 0) {
            return OK;
        }
        CheckErrorInfo result = CONVERSION.get(response.getCheckErrors(0).getCode());
        if (result == null) {
            return UNKNOWN;
        }
        return result;
    }

    static {
        CONVERSION = Maps.newHashMap();
        for (CheckErrorInfo i : CheckErrorInfo.values()) {
            if (i.code == CheckError.Code.UNRECOGNIZED) continue;
            CONVERSION.put(i.code, i);
        }
    }
}

