/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.OperationInfo;
import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import java.util.Map;

public class CheckRequestInfo
extends OperationInfo {
    @VisibleForTesting
    static final String ANDROID_PACKAGE_LABEL = "servicecontrol.googleapis.com/android_package_name";
    @VisibleForTesting
    static final String ANDROID_CERTIFICATE_FINGERPRINT_LABEL = "servicecontrol.googleapis.com/android_cert_fingerprint";
    @VisibleForTesting
    static final String IOS_BUNDLE_ID = "servicecontrol.googleapis.com/ios_bundle_id";
    private String clientIp;
    private String androidPackageName;
    private String androidCertificateFingerprint;
    private String iosBundleId;

    public CheckRequestInfo() {
    }

    public CheckRequestInfo(OperationInfo o) {
        this.setApiKey(o.getApiKey());
        this.setApiKeyValid(o.isApiKeyValid());
        this.setConsumerProjectId(o.getConsumerProjectId());
        this.setOperationId(o.getOperationId());
        this.setOperationName(o.getOperationName());
        this.setReferer(o.getReferer());
        this.setServiceName(o.getServiceName());
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public CheckRequestInfo setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public String getAndroidPackageName() {
        return this.androidPackageName;
    }

    public CheckRequestInfo setAndroidPackageName(String androidPackageName) {
        this.androidPackageName = androidPackageName;
        return this;
    }

    public String getAndroidCertificateFingerprint() {
        return this.androidCertificateFingerprint;
    }

    public CheckRequestInfo setAndroidCertificateFingerprint(String androidCertificateFingerprint) {
        this.androidCertificateFingerprint = androidCertificateFingerprint;
        return this;
    }

    public String getIosBundleId() {
        return this.iosBundleId;
    }

    public CheckRequestInfo setIosBundleId(String iosBundleId) {
        this.iosBundleId = iosBundleId;
        return this;
    }

    public CheckRequest asCheckRequest(Clock clock) {
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getServiceName()), "a service name must be set");
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getOperationId()), "an operation ID must be set");
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getOperationName()), "an operation name must be set");
        Operation.Builder b = super.asOperation(clock).toBuilder();
        b.putAllLabels(this.getSystemLabels());
        return CheckRequest.newBuilder().setServiceName(this.getServiceName()).setOperation(b).build();
    }

    @Override
    protected Map<String, String> getSystemLabels() {
        Map<String, String> labels = super.getSystemLabels();
        if (!Strings.isNullOrEmpty(this.getClientIp())) {
            labels.put("servicecontrol.googleapis.com/caller_ip", this.getClientIp());
        }
        if (!Strings.isNullOrEmpty(this.getReferer())) {
            labels.put("servicecontrol.googleapis.com/referer", this.getReferer());
        }
        if (!Strings.isNullOrEmpty(this.getAndroidPackageName())) {
            labels.put(ANDROID_PACKAGE_LABEL, this.getAndroidPackageName());
        }
        if (!Strings.isNullOrEmpty(this.getAndroidCertificateFingerprint())) {
            labels.put(ANDROID_CERTIFICATE_FINGERPRINT_LABEL, this.getAndroidCertificateFingerprint());
        }
        if (!Strings.isNullOrEmpty(this.getIosBundleId())) {
            labels.put(IOS_BUNDLE_ID, this.getIosBundleId());
        }
        return labels;
    }
}

