/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.ReportRequestInfo;
import endpoints.repackaged.com.google.api.LabelDescriptor;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;

public enum KnownLabels {
    CREDENTIAL_ID("/credential_id", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (!Strings.isNullOrEmpty(info.getApiKey())) {
                labels.put(name, String.format("apiKey:%s", info.getApiKey()));
            } else if (!Strings.isNullOrEmpty(info.getAuthIssuer())) {
                BaseEncoding encoder = BaseEncoding.base64Url();
                if (!Strings.isNullOrEmpty(info.getAuthAudience())) {
                    labels.put(name, String.format("jwtAuth:issuer=%s&audience=%s", encoder.encode(info.getAuthIssuer().getBytes(StandardCharsets.UTF_8)), encoder.encode(info.getAuthAudience().getBytes(StandardCharsets.UTF_8))));
                } else {
                    labels.put(name, String.format("jwtAuth:issuer=%s", encoder.encode(info.getAuthIssuer().getBytes(StandardCharsets.UTF_8))));
                }
            }
        }
    }),
    END_USER("/end_user", LabelDescriptor.ValueType.STRING, Kind.USER, null),
    END_USER_COUNTRY("/end_user_country", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    ERROR_TYPE("/error_type", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (info.getResponseCode() > 0) {
                labels.put(name, String.format("%dxx", info.getResponseCode() / 100));
            }
        }
    }),
    PROTOCOL("/protocol", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (info.getProtocol() != null) {
                labels.put(name, info.getProtocol().name());
            } else {
                labels.put(name, ReportRequestInfo.ReportedProtocols.UNKNOWN.name());
            }
        }
    }),
    REFERER("/referer", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (!Strings.isNullOrEmpty(info.getReferer())) {
                labels.put(name, info.getReferer());
            }
        }
    }),
    RESPONSE_CODE("/response_code", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            labels.put(name, String.format("%d", info.getResponseCode()));
        }
    }),
    RESPONSE_CODE_CLASS("/response_code_class", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (info.getResponseCode() > 0) {
                labels.put(name, String.format("%dxx", info.getResponseCode() / 100));
            }
        }
    }),
    STATUS_CODE("/status_code", LabelDescriptor.ValueType.STRING, Kind.USER, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (info.getResponseCode() > 0) {
                labels.put(name, String.format("%d", KnownLabels.cannonicalCodeOf(info.getResponseCode())));
            }
        }
    }),
    GAE_CLONE_ID("appengine.googleapis.com/clone_id", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    GAE_MODULE_ID("appengine.googleapis.com/module_id", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    GAE_REPLICA_INDEX("appengine.googleapis.com/replica_index", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    GAE_VERSION_ID("appengine.googleapis.com/version_id", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    GCP_LOCATION("cloud.googleapis.com/location", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (!Strings.isNullOrEmpty(info.getLocation())) {
                labels.put(name, info.getLocation());
            } else {
                labels.put(name, "global");
            }
        }
    }),
    GCP_PROJECT("cloud.googleapis.com/project", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, KnownLabels.noUpdate()),
    GCP_REGION("cloud.googleapis.com/region", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, KnownLabels.noUpdate()),
    GCP_RESOURCE_ID("cloud.googleapis.com/resource_id", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    GCP_RESOURCE_TYPE("cloud.googleapis.com/resource_type", LabelDescriptor.ValueType.STRING, Kind.USER, KnownLabels.noUpdate()),
    GCP_SERVICE("cloud.googleapis.com/service", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, KnownLabels.noUpdate()),
    GCP_ZONE("cloud.googleapis.com/zone", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, KnownLabels.noUpdate()),
    GCP_UID("cloud.googleapis.com/uid", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, KnownLabels.noUpdate()),
    SVC_API_METHOD("serviceruntime.googleapis.com/api_method", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (!Strings.isNullOrEmpty(info.getApiMethod())) {
                labels.put(name, info.getApiMethod());
            }
        }
    }),
    SVC_API_VERSION("serviceruntime.googleapis.com/api_version", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (!Strings.isNullOrEmpty(info.getApiVersion())) {
                labels.put(name, info.getApiVersion());
            }
        }
    }),
    SCC_PLATFORM("servicecontrol.googleapis.com/platform", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (info.getPlatform() != null) {
                labels.put(name, info.getPlatform().getName());
            } else {
                labels.put(name, ReportRequestInfo.ReportedPlatforms.UNKNOWN.getName());
            }
        }
    }),
    SCC_REFERER("servicecontrol.googleapis.com/referer", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, KnownLabels.noUpdate()),
    SCC_SERVICE_AGENT("servicecontrol.googleapis.com/service_agent", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            labels.put(name, SERVICE_AGENT);
        }
    }),
    SCC_USER_AGENT("servicecontrol.googleapis.com/user_agent", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            labels.put(name, KnownLabels.USER_AGENT);
        }
    }),
    SCC_CONSUMER_PROJECT("serviceruntime.googleapis.com/consumer_project", LabelDescriptor.ValueType.STRING, Kind.SYSTEM, new Update(){

        @Override
        public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            if (info.getConsumerProjectNumber() > 0L) {
                labels.put(name, Long.toString(info.getConsumerProjectNumber()));
            }
        }
    });

    public static final Update NO_UPDATE;
    public static final String USER_AGENT = "ESP";
    public static final String SERVICE_AGENT;
    private String name;
    private LabelDescriptor.ValueType type;
    private Update updater;
    private Kind kind;
    private static final Map<Integer, Integer> CANNONICAL_CODES;

    private KnownLabels(String name, LabelDescriptor.ValueType type, Kind kind, Update updater) {
        this.name = name;
        this.type = type;
        this.kind = kind;
        this.updater = updater;
    }

    public String getName() {
        return this.name;
    }

    public LabelDescriptor.ValueType getType() {
        return this.type;
    }

    public Update getUpdater() {
        return this.updater;
    }

    public boolean matches(LabelDescriptor d) {
        return this.name.equals(d.getKey()) && d.getValueType() == this.type;
    }

    public void performUpdate(ReportRequestInfo info, Map<String, String> labels) {
        if (this.updater != null) {
            this.updater.update(this.name, info, labels);
        }
    }

    public static boolean isSupported(LabelDescriptor d) {
        for (KnownLabels l : KnownLabels.values()) {
            if (!l.matches(d)) continue;
            return true;
        }
        return false;
    }

    private static Update noUpdate() {
        return NO_UPDATE;
    }

    private static int cannonicalCodeOf(int httpCode) {
        if (CANNONICAL_CODES.containsKey(httpCode)) {
            return CANNONICAL_CODES.get(httpCode);
        }
        if (httpCode >= 200 && httpCode < 300) {
            return 0;
        }
        if (httpCode >= 400 && httpCode < 500) {
            return 9;
        }
        if (httpCode >= 500 && httpCode < 600) {
            return 13;
        }
        return 2;
    }

    private static String getServiceAgent() {
        InputStream in = KnownLabels.class.getResourceAsStream("version.properties");
        Properties properties = new Properties();
        try {
            properties.load(in);
            return "EF_JAVA/" + properties.getProperty("version");
        }
        catch (IOException e) {
            return "EF_JAVA/UNKNOWN";
        }
    }

    static {
        NO_UPDATE = new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Map<String, String> labels) {
            }
        };
        SERVICE_AGENT = KnownLabels.getServiceAgent();
        CANNONICAL_CODES = ImmutableMap.builder().put(200, 0).put(400, 3).put(401, 16).put(403, 7).put(404, 5).put(409, 10).put(412, 9).put(416, 11).put(429, 8).put(499, 1).put(500, 13).put(504, 4).put(501, 12).put(503, 14).build();
    }

    private static enum Kind {
        USER,
        SYSTEM;

    }

    public static interface Update {
        public void update(String var1, ReportRequestInfo var2, Map<String, String> var3);
    }
}

