/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.Distributions;
import com.google.api.control.model.ReportRequestInfo;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Distribution;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValue;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValueSet;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;

public enum KnownMetrics {
    CONSUMER_REQUEST_COUNT("serviceruntime.googleapis.com/api/consumer/request_count", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.INT64, KnownMetrics.add1ToInt64Metric(), Mark.CONSUMER),
    PRODUCER_REQUEST_COUNT("serviceruntime.googleapis.com/api/producer/request_count", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.INT64, KnownMetrics.add1ToInt64Metric()),
    PRODUCER_BY_CONSUMER_REQUEST_COUNT("serviceruntime.googleapis.com/api/producer/by_consumer/request_count", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.INT64, KnownMetrics.add1ToInt64Metric(), Mark.PRODUCER_BY_CONSUMER),
    CONSUMER_REQUEST_SIZES("serviceruntime.googleapis.com/api/consumer/request_sizes", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForRequestSize(), Mark.CONSUMER),
    PRODUCER_REQUEST_SIZES("serviceruntime.googleapis.com/api/producer/request_sizes", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForRequestSize()),
    PRODUCER_BY_CONSUMER_REQUEST_SIZES("serviceruntime.googleapis.com/api/producer/by_consumer/request_sizes", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForRequestSize(), Mark.PRODUCER_BY_CONSUMER),
    CONSUMER_RESPONSE_SIZES("serviceruntime.googleapis.com/api/consumer/response_sizes", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForResponseSize(), Mark.CONSUMER),
    PRODUCER_RESPONSE_SIZES("serviceruntime.googleapis.com/api/producer/response_sizes", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForResponseSize()),
    PRODUCER_BY_CONSUMER_RESPONSE_SIZES("serviceruntime.googleapis.com/api/producer/by_consumer/response_sizes", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForResponseSize(), Mark.PRODUCER_BY_CONSUMER),
    CONSUMER_REQUEST_ERROR_COUNT("serviceruntime.googleapis.com/api/consumer/error_count", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.INT64, KnownMetrics.add1ToInt64MetricIfError(), Mark.CONSUMER),
    PRODUCER_REQUEST_ERROR_COUNT("serviceruntime.googleapis.com/api/producer/error_count", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.INT64, KnownMetrics.add1ToInt64MetricIfError()),
    PRODUCER_BY_CONSUMER_ERROR_COUNT("serviceruntime.googleapis.com/api/producer/by_consumer/error_count", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.INT64, KnownMetrics.add1ToInt64MetricIfError(), Mark.PRODUCER_BY_CONSUMER),
    CONSUMER_TOTAL_LATENCIES("serviceruntime.googleapis.com/api/consumer/total_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForRequestTimeMillis(), Mark.CONSUMER),
    PRODUCER_TOTAL_LATENCIES("serviceruntime.googleapis.com/api/producer/total_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForRequestTimeMillis()),
    PRODUCER_BY_CONSUMER_TOTAL_LATENCIES("serviceruntime.googleapis.com/api/producer/by_consumer/total_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForRequestTimeMillis(), Mark.PRODUCER_BY_CONSUMER),
    CONSUMER_BACKEND_LATENCIES("serviceruntime.googleapis.com/api/consumer/backend_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForBackendTimeMillis(), Mark.CONSUMER),
    PRODUCER_BACKEND_LATENCIES("serviceruntime.googleapis.com/api/producer/backend_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForBackendTimeMillis()),
    PRODUCER_BY_CONSUMER_BACKEND_LATENCIES("serviceruntime.googleapis.com/api/producer/by_consumer/backend_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForBackendTimeMillis(), Mark.PRODUCER_BY_CONSUMER),
    CONSUMER_REQUEST_OVERHEAD_LATENCIES("serviceruntime.googleapis.com/api/consumer/request_overhead_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForOverheadTimeMillis(), Mark.CONSUMER),
    PRODUCER_REQUEST_OVERHEAD_LATENCIES("serviceruntime.googleapis.com/api/producer/request_overhead_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForOverheadTimeMillis()),
    PRODUCER_BY_CONSUMER_REQUEST_OVERHEAD_LATENCIES("serviceruntime.googleapis.com/api/producer/by_consumer/request_overhead_latencies", MetricDescriptor.MetricKind.DELTA, MetricDescriptor.ValueType.DISTRIBUTION, KnownMetrics.addDistributionMetricForOverheadTimeMillis(), Mark.PRODUCER_BY_CONSUMER);

    private static final double TIME_SCALE = 1.0E-6;
    private static final double SIZE_SCALE = 1.0;
    private static final double DISTRIBUTION_GROWTH_FACTOR = 10.0;
    private static final int DISTRIBUTION_BUCKETS = 8;
    private static final double MILLIS_PER_SEC = 1000.0;
    private String name;
    private MetricDescriptor.MetricKind kind;
    private MetricDescriptor.ValueType type;
    private Update updater;
    private Mark mark;

    private KnownMetrics(String name, MetricDescriptor.MetricKind kind, MetricDescriptor.ValueType type, Update updater) {
        this(name, kind, type, updater, Mark.PRODUCER);
    }

    private KnownMetrics(String name, MetricDescriptor.MetricKind kind, MetricDescriptor.ValueType type, Update updater, Mark mark) {
        this.name = name;
        this.type = type;
        this.kind = kind;
        this.updater = mark == Mark.CONSUMER ? KnownMetrics.consumerMetric(updater) : (mark == Mark.PRODUCER_BY_CONSUMER ? KnownMetrics.producerByConsumerMetric(updater) : updater);
        this.mark = mark;
    }

    public String getName() {
        return this.name;
    }

    public MetricDescriptor.MetricKind getKind() {
        return this.kind;
    }

    public MetricDescriptor.ValueType getType() {
        return this.type;
    }

    public Update getUpdater() {
        return this.updater;
    }

    public boolean matches(MetricDescriptor d) {
        return this.name.equals(d.getName()) && d.getMetricKind() == this.kind && d.getValueType() == this.type;
    }

    public static boolean isSupported(MetricDescriptor d) {
        for (KnownMetrics m : KnownMetrics.values()) {
            if (!m.matches(d)) continue;
            return true;
        }
        return false;
    }

    public void performUpdate(ReportRequestInfo info, Operation.Builder o) {
        if (this.updater != null) {
            this.updater.update(this.name, info, o);
        }
    }

    static Distribution newSizeDistribution() {
        return Distributions.createExponential(8, 10.0, 1.0);
    }

    static Distribution newTimeDistribution() {
        return Distributions.createExponential(8, 10.0, 1.0E-6);
    }

    private static Update add1ToInt64Metric() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                KnownMetrics.add1ToInt64MetricValue(name, op);
            }
        };
    }

    private static Update add1ToInt64MetricIfError() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getResponseCode() >= 400) {
                    KnownMetrics.add1ToInt64MetricValue(name, op);
                }
            }
        };
    }

    private static Update consumerMetric(final Update delegate) {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.isApiKeyValid()) {
                    delegate.update(name, info, op);
                }
            }
        };
    }

    private static Update producerByConsumerMetric(final Update delegate) {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getConsumerProjectNumber() > 0L) {
                    delegate.update(name, info, op);
                }
            }
        };
    }

    private static void addInt64MetricValue(String name, long value, Operation.Builder op) {
        op.addMetricValueSets(MetricValueSet.newBuilder().setMetricName(name).addMetricValues(MetricValue.newBuilder().setInt64Value(value).build()));
    }

    private static void add1ToInt64MetricValue(String name, Operation.Builder op) {
        KnownMetrics.addInt64MetricValue(name, 1L, op);
    }

    private static Update addDistributionMetricForResponseSize() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getResponseSize() > 0L) {
                    KnownMetrics.addSizeDistributionMetricValue(name, info.getResponseSize(), op);
                }
            }
        };
    }

    private static Update addDistributionMetricForRequestSize() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getRequestSize() > 0L) {
                    KnownMetrics.addSizeDistributionMetricValue(name, info.getRequestSize(), op);
                }
            }
        };
    }

    private static Update addDistributionMetricForRequestTimeMillis() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getRequestTimeMillis() > 0L) {
                    KnownMetrics.addTimeDistributionMetricValue(name, info.getRequestTimeMillis(), op);
                }
            }
        };
    }

    private static Update addDistributionMetricForBackendTimeMillis() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getBackendTimeMillis() > 0L) {
                    KnownMetrics.addTimeDistributionMetricValue(name, info.getBackendTimeMillis(), op);
                }
            }
        };
    }

    private static Update addDistributionMetricForOverheadTimeMillis() {
        return new Update(){

            @Override
            public void update(String name, ReportRequestInfo info, Operation.Builder op) {
                if (info.getOverheadTimeMillis() > 0L) {
                    KnownMetrics.addTimeDistributionMetricValue(name, info.getOverheadTimeMillis(), op);
                }
            }
        };
    }

    private static void addTimeDistributionMetricValue(String name, long value, Operation.Builder op) {
        Distribution d = Distributions.addSample((double)value / 1000.0, KnownMetrics.newTimeDistribution());
        op.addMetricValueSets(MetricValueSet.newBuilder().setMetricName(name).addMetricValues(MetricValue.newBuilder().setDistributionValue(d).build()));
    }

    private static void addSizeDistributionMetricValue(String name, long value, Operation.Builder op) {
        Distribution d = Distributions.addSample(value, KnownMetrics.newSizeDistribution());
        op.addMetricValueSets(MetricValueSet.newBuilder().setMetricName(name).addMetricValues(MetricValue.newBuilder().setDistributionValue(d).build()));
    }

    private static enum Mark {
        PRODUCER,
        CONSUMER,
        PRODUCER_BY_CONSUMER;

    }

    private static interface Update {
        public void update(String var1, ReportRequestInfo var2, Operation.Builder var3);
    }
}

