/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.AutoValue_MethodRegistry_QuotaInfo;
import com.google.api.control.model.PathTemplate;
import com.google.api.control.model.ValidationException;
import com.google.api.control.util.StringUtils;
import com.google.auto.value.AutoValue;
import endpoints.repackaged.com.google.api.AuthRequirement;
import endpoints.repackaged.com.google.api.AuthenticationRule;
import endpoints.repackaged.com.google.api.HttpRule;
import endpoints.repackaged.com.google.api.MetricRule;
import endpoints.repackaged.com.google.api.Service;
import endpoints.repackaged.com.google.api.SystemParameter;
import endpoints.repackaged.com.google.api.SystemParameterRule;
import endpoints.repackaged.com.google.api.UsageRule;
import endpoints.repackaged.com.google.common.base.Optional;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.com.google.common.collect.ImmutableSet;
import endpoints.repackaged.com.google.common.collect.Lists;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.collect.Sets;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

public class MethodRegistry {
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private static final String OPTIONS_VERB = "OPTIONS";
    private final Service theService;
    private final Map<String, AuthInfo> authInfos;
    private final Map<String, QuotaInfo> quotaInfos;
    private final Map<String, List<Info>> infosByHttpMethod;
    private final Map<String, Info> extractedMethods;

    public MethodRegistry(Service s) {
        Preconditions.checkNotNull(s, "The service must be specified");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(s.getName()), "The service name must be specified");
        this.theService = s;
        this.infosByHttpMethod = Maps.newHashMap();
        this.extractedMethods = Maps.newHashMap();
        this.authInfos = MethodRegistry.extractAuth(s);
        this.quotaInfos = MethodRegistry.extractQuota(s);
        this.extractMethods();
    }

    @Nullable
    public Info lookup(String httpMethod, String url) {
        httpMethod = httpMethod.toLowerCase();
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        url = StringUtils.stripTrailingSlash(url);
        List<Info> infos = this.infosByHttpMethod.get(httpMethod);
        if (infos == null) {
            ((FluentLogger.Api)log.atFine()).log("no information about any urls for HTTP method %s when checking %s", (Object)httpMethod, (Object)url);
            return null;
        }
        for (Info info : infos) {
            ((FluentLogger.Api)log.atFine()).log("trying %s with template %s", (Object)url, (Object)info.getTemplate());
            if (info.getTemplate().matches(url)) {
                ((FluentLogger.Api)log.atFine()).log("%s matched %s", (Object)url, (Object)info.getTemplate());
                return info;
            }
            ((FluentLogger.Api)log.atFine()).log("%s did not matched %s", (Object)url, (Object)info.getTemplate());
        }
        return null;
    }

    private void extractMethods() {
        if (!this.theService.hasHttp()) {
            return;
        }
        List<HttpRule> rules = this.theService.getHttp().getRulesList();
        HashSet<String> allUrls = Sets.newHashSet();
        HashSet<String> urlsWithOptions = Sets.newHashSet();
        for (HttpRule r : rules) {
            String url = StringUtils.stripTrailingSlash(MethodRegistry.urlFrom(r));
            String httpMethod = MethodRegistry.httpMethodFrom(r);
            if (Strings.isNullOrEmpty(url) || Strings.isNullOrEmpty(httpMethod) || Strings.isNullOrEmpty(r.getSelector())) {
                ((FluentLogger.Api)log.atWarning()).log("invalid HTTP binding detected");
                continue;
            }
            Info theMethod = this.getOrCreateInfo(r.getSelector());
            if (!Strings.isNullOrEmpty(r.getBody())) {
                theMethod.setBodyFieldPath(r.getBody());
            }
            if (!this.register(httpMethod, url, theMethod)) continue;
            allUrls.add(url);
            if (!httpMethod.equals(OPTIONS_VERB)) continue;
            urlsWithOptions.add(url);
        }
        allUrls.removeAll(urlsWithOptions);
        this.addCorsOptionSelectors(allUrls);
        this.updateUsage();
        this.updateSystemParameters();
    }

    private boolean register(String httpMethod, String url, Info theMethod) {
        try {
            PathTemplate t = PathTemplate.create(url);
            theMethod.setTemplate(t);
            List<Info> infos = this.infosByHttpMethod.get(httpMethod);
            if (infos == null) {
                infos = Lists.newArrayList();
                this.infosByHttpMethod.put(httpMethod.toLowerCase(), infos);
            }
            infos.add(theMethod);
            ((FluentLogger.Api)log.atFine()).log("registered template %s under method %s", (Object)t, (Object)httpMethod);
            return true;
        }
        catch (ValidationException e) {
            ((FluentLogger.Api)log.atWarning()).log("invalid HTTP template %s provided", url);
            return false;
        }
    }

    private void addCorsOptionSelectors(Set<String> allUrls) {
        String baseSelector;
        String optionsSelector = baseSelector = String.format("%s.%s", this.theService.getName(), OPTIONS_VERB);
        int index = 0;
        Info info = this.extractedMethods.get(optionsSelector);
        while (info != null) {
            optionsSelector = String.format("%s.%d", baseSelector, ++index);
            info = this.extractedMethods.get(optionsSelector);
        }
        Info newInfo = this.getOrCreateInfo(optionsSelector);
        newInfo.setAllowUnregisteredCalls(true);
        for (String u : allUrls) {
            this.register(OPTIONS_VERB, u, newInfo);
        }
    }

    private void updateSystemParameters() {
        if (!this.theService.hasSystemParameters()) {
            return;
        }
        for (SystemParameterRule r : this.theService.getSystemParameters().getRulesList()) {
            Info info = this.extractedMethods.get(r.getSelector());
            if (info == null) {
                ((FluentLogger.Api)log.atWarning()).log("bad system parameter: no HTTP rule for %s", r.getSelector());
                continue;
            }
            for (SystemParameter parameter : r.getParametersList()) {
                if (Strings.isNullOrEmpty(parameter.getName())) {
                    ((FluentLogger.Api)log.atWarning()).log("bad system parameter: no parameter name for %s", r.getSelector());
                    continue;
                }
                if (!Strings.isNullOrEmpty(parameter.getHttpHeader())) {
                    info.addHeaderParam(parameter.getName(), parameter.getHttpHeader());
                }
                if (Strings.isNullOrEmpty(parameter.getUrlQueryParameter())) continue;
                info.addHeaderParam(parameter.getName(), parameter.getUrlQueryParameter());
            }
        }
    }

    private void updateUsage() {
        if (!this.theService.hasUsage()) {
            return;
        }
        for (UsageRule r : this.theService.getUsage().getRulesList()) {
            Info info = this.extractedMethods.get(r.getSelector());
            if (info == null) {
                ((FluentLogger.Api)log.atWarning()).log("bad usage selector: no HTTP rule for %s", r.getSelector());
                continue;
            }
            info.setAllowUnregisteredCalls(r.getAllowUnregisteredCalls());
        }
    }

    private Info getOrCreateInfo(String selector) {
        Info i = this.extractedMethods.get(selector);
        if (i != null) {
            return i;
        }
        i = new Info(selector, this.authInfos.get(selector), this.quotaInfos.get(selector));
        this.extractedMethods.put(selector, i);
        return i;
    }

    private static String httpMethodFrom(HttpRule r) {
        switch (r.getPatternCase()) {
            case CUSTOM: {
                return r.getCustom().getKind().toLowerCase();
            }
            case DELETE: 
            case GET: 
            case PATCH: 
            case POST: 
            case PUT: {
                return r.getPatternCase().toString().toLowerCase();
            }
        }
        return null;
    }

    private static String urlFrom(HttpRule r) {
        switch (r.getPatternCase()) {
            case CUSTOM: {
                return r.getCustom().getKind();
            }
            case DELETE: {
                return r.getDelete();
            }
            case GET: {
                return r.getGet();
            }
            case PATCH: {
                return r.getPatch();
            }
            case POST: {
                return r.getPost();
            }
            case PUT: {
                return r.getPut();
            }
        }
        return null;
    }

    private static Map<String, AuthInfo> extractAuth(Service service) {
        if (!service.hasAuthentication()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, AuthInfo> authInfoBuilder = ImmutableMap.builder();
        for (AuthenticationRule authRule : service.getAuthentication().getRulesList()) {
            ImmutableMap.Builder<String, ImmutableSet<String>> providerToAudienceBuilder = ImmutableMap.builder();
            for (AuthRequirement requirement : authRule.getRequirementsList()) {
                providerToAudienceBuilder.put(requirement.getProviderId(), ImmutableSet.copyOf(requirement.getAudiences().split(",")));
            }
            AuthInfo authInfo = new AuthInfo(providerToAudienceBuilder.build());
            authInfoBuilder.put(authRule.getSelector(), authInfo);
        }
        return authInfoBuilder.build();
    }

    private static Map<String, QuotaInfo> extractQuota(Service service) {
        if (!service.hasQuota()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder<String, QuotaInfo> quotaInfoBuilder = ImmutableMap.builder();
        for (MetricRule metricRule : service.getQuota().getMetricRulesList()) {
            quotaInfoBuilder.put(metricRule.getSelector(), QuotaInfo.create(metricRule.getMetricCostsMap()));
        }
        return quotaInfoBuilder.build();
    }

    @AutoValue
    public static abstract class QuotaInfo {
        public static final QuotaInfo DEFAULT = QuotaInfo.create(ImmutableMap.of());

        public abstract Map<String, Long> getMetricCosts();

        public static QuotaInfo create(Map<String, Long> metricCosts) {
            return new AutoValue_MethodRegistry_QuotaInfo(metricCosts);
        }
    }

    public static final class AuthInfo {
        private final Map<String, Set<String>> providerIdsToAudiences;

        public AuthInfo(Map<String, Set<String>> providerIdsToAudiences) {
            Preconditions.checkNotNull(providerIdsToAudiences);
            this.providerIdsToAudiences = providerIdsToAudiences;
        }

        public boolean isProviderIdAllowed(String providerid) {
            Preconditions.checkNotNull(providerid);
            return this.providerIdsToAudiences.containsKey(providerid);
        }

        public Set<String> getAudiencesForProvider(String providerId) {
            Preconditions.checkNotNull(providerId);
            if (this.providerIdsToAudiences.containsKey(providerId)) {
                return this.providerIdsToAudiences.get(providerId);
            }
            return ImmutableSet.of();
        }
    }

    public static class Info {
        private static final String API_KEY_NAME = "api_key";
        private final Optional<AuthInfo> authInfo;
        private final QuotaInfo quotaInfo;
        private boolean allowUnregisteredCalls;
        private String selector;
        private String backendAddress;
        private String bodyFieldPath;
        private Map<String, List<String>> urlQueryParams;
        private Map<String, List<String>> headerParams;
        private PathTemplate template;

        public Info(String selector, @CheckForNull AuthInfo authInfo, @CheckForNull QuotaInfo quotaInfo) {
            this.selector = selector;
            this.authInfo = Optional.fromNullable(authInfo);
            this.quotaInfo = quotaInfo != null ? quotaInfo : QuotaInfo.DEFAULT;
            this.urlQueryParams = Maps.newHashMap();
            this.headerParams = Maps.newHashMap();
        }

        public PathTemplate getTemplate() {
            return this.template;
        }

        public void setTemplate(PathTemplate template) {
            this.template = template;
        }

        public void addUrlQueryParam(String name, String param) {
            List<String> l = this.urlQueryParams.get(name);
            if (l == null) {
                l = Lists.newArrayList();
                this.urlQueryParams.put(name, l);
            }
            l.add(param);
        }

        public List<String> urlQueryParam(String name) {
            List<String> l = this.urlQueryParams.get(name);
            if (l == null) {
                return Collections.emptyList();
            }
            return ImmutableList.copyOf(l);
        }

        public List<String> apiKeyUrlQueryParam() {
            return this.urlQueryParam(API_KEY_NAME);
        }

        public void addHeaderParam(String name, String param) {
            List<String> l = this.headerParams.get(name);
            if (l == null) {
                l = Lists.newArrayList();
                this.headerParams.put(name, l);
            }
            l.add(param);
        }

        public List<String> headerParam(String name) {
            List<String> l = this.headerParams.get(name);
            if (l == null) {
                return Collections.emptyList();
            }
            return ImmutableList.copyOf(l);
        }

        public List<String> apiKeyHeaderParam() {
            return this.headerParam(API_KEY_NAME);
        }

        public Optional<AuthInfo> getAuthInfo() {
            return this.authInfo;
        }

        public QuotaInfo getQuotaInfo() {
            return this.quotaInfo;
        }

        public boolean shouldAllowUnregisteredCalls() {
            return this.allowUnregisteredCalls;
        }

        public void setAllowUnregisteredCalls(boolean allowRegisteredCalls) {
            this.allowUnregisteredCalls = allowRegisteredCalls;
        }

        public String getSelector() {
            return this.selector;
        }

        public void setSelector(String selector) {
            this.selector = selector;
        }

        public String getBackendAddress() {
            return this.backendAddress;
        }

        public void setBackendAddress(String backendAddress) {
            this.backendAddress = backendAddress;
        }

        public String getBodyFieldPath() {
            return this.bodyFieldPath;
        }

        public void setBodyFieldPath(String bodyFieldPath) {
            this.bodyFieldPath = bodyFieldPath;
        }
    }
}

