/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import endpoints.repackaged.google.type.Money;

public final class Moneys {
    private static int BILLION = 1000000000;
    public static int MAX_NANOS = BILLION - 1;
    private static final String MSG_POSITIVE_OVERFLOW = "Addition failed due to positive overflow";
    private static final String MSG_NEGATIVE_OVERFLOW = "Addition failed due to negative overflow";
    private static final String MSG_3_LETTERS_LONG = "The currency code is not 3 letters long";
    private static final String MSG_UNITS_NANOS_MISMATCH = "The signs of the units and nanos do not match";
    private static final String MSG_NANOS_OOB = "The nanos field must be between -999,999,999 and 999,999,999";
    private static final String MSG_SAME_CURRENCY = "Money values need the same currency to be summed";

    private Moneys() {
    }

    public static void checkValid(Money value) {
        String currencyCode = value.getCurrencyCode();
        if (currencyCode == null || currencyCode.length() != 3) {
            throw new IllegalArgumentException(MSG_3_LETTERS_LONG);
        }
        long units = value.getUnits();
        int nanos = value.getNanos();
        if (units > 0L && nanos < 0 || units < 0L && nanos > 0) {
            throw new IllegalArgumentException(MSG_UNITS_NANOS_MISMATCH);
        }
        if (Math.abs(nanos) > MAX_NANOS) {
            throw new IllegalArgumentException(MSG_NANOS_OOB);
        }
    }

    public static Money add(Money a, Money b, boolean allowOverflow) {
        if (!a.getCurrencyCode().equals(b.getCurrencyCode())) {
            throw new IllegalArgumentException(MSG_SAME_CURRENCY);
        }
        SumResult nanoSum = Moneys.innerSum(a.getNanos(), b.getNanos());
        long unitSumNoCarry = a.getUnits() + b.getUnits();
        long unitSum = unitSumNoCarry + (long)nanoSum.carry;
        if (unitSum > 0L && nanoSum.sum < 0) {
            --unitSum;
            nanoSum.sum += BILLION;
        } else if (unitSum < 0L && nanoSum.sum > 0) {
            --unitSum;
            nanoSum.sum -= BILLION;
        }
        int signOfA = Moneys.signOf(a);
        int signOfB = Moneys.signOf(b);
        if (signOfA > 0 && signOfB > 0 && unitSum < 0L) {
            if (!allowOverflow) {
                throw new ArithmeticException(MSG_POSITIVE_OVERFLOW);
            }
            return Money.newBuilder().setCurrencyCode(a.getCurrencyCode()).setNanos(MAX_NANOS).setUnits(Long.MAX_VALUE).build();
        }
        if (signOfA < 0 && signOfB < 0 && (unitSumNoCarry >= 0L || unitSum >= 0L)) {
            if (!allowOverflow) {
                throw new ArithmeticException(MSG_NEGATIVE_OVERFLOW);
            }
            return Money.newBuilder().setCurrencyCode(a.getCurrencyCode()).setNanos(-MAX_NANOS).setUnits(Long.MIN_VALUE).build();
        }
        return Money.newBuilder().setCurrencyCode(a.getCurrencyCode()).setNanos(nanoSum.sum).setUnits(unitSum).build();
    }

    public static Money add(Money a, Money b) {
        return Moneys.add(a, b, false);
    }

    private static SumResult innerSum(int a, int b) {
        SumResult result = new SumResult();
        result.sum = a + b;
        if (result.sum > BILLION) {
            result.carry = 1;
            result.sum -= BILLION;
        } else if (result.sum < -BILLION) {
            result.carry = -1;
            result.sum += BILLION;
        }
        return result;
    }

    private static int signOf(Money m) {
        if (m.getUnits() > 0L) {
            return 1;
        }
        if (m.getUnits() < 0L) {
            return -1;
        }
        if (m.getNanos() > 0) {
            return 1;
        }
        if (m.getNanos() < 0) {
            return -1;
        }
        return 0;
    }

    private static class SumResult {
        public int sum;
        public int carry;

        private SumResult() {
        }
    }
}

