/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.KnownLabels;
import com.google.api.control.model.Timestamps;
import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.google.protobuf.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class OperationInfo {
    public static final String SCC_CALLER_IP = "servicecontrol.googleapis.com/caller_ip";
    public static final String SCC_USER_AGENT = "servicecontrol.googleapis.com/user_agent";
    public static final String SCC_SERVICE_AGENT = "servicecontrol.googleapis.com/service_agent";
    public static final String SCC_REFERER = "servicecontrol.googleapis.com/referer";
    private boolean apiKeyValid;
    private String apiKey;
    private String consumerProjectId;
    private String operationId;
    private String operationName;
    private String referer;
    private String serviceName;
    private String serviceConfigId;

    public Operation asOperation(Clock clock) {
        String consumerId;
        Operation.Builder b = Operation.newBuilder();
        b.setImportance(Operation.Importance.LOW);
        Timestamp now = Timestamps.now(clock);
        b.setStartTime(now).setEndTime(now);
        if (!Strings.isNullOrEmpty(this.operationId)) {
            b.setOperationId(this.operationId);
        }
        if (!Strings.isNullOrEmpty(this.operationName)) {
            b.setOperationName(this.operationName);
        }
        if (!Strings.isNullOrEmpty(consumerId = this.getOperationConsumerId())) {
            b.setConsumerId(consumerId);
        }
        return b.build();
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public OperationInfo setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public boolean isApiKeyValid() {
        return this.apiKeyValid;
    }

    public OperationInfo setApiKeyValid(boolean apiKeyValid) {
        this.apiKeyValid = apiKeyValid;
        return this;
    }

    public String getConsumerProjectId() {
        return this.consumerProjectId;
    }

    public OperationInfo setConsumerProjectId(String consumerProjectId) {
        this.consumerProjectId = consumerProjectId;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public OperationInfo setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public OperationInfo setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public String getReferer() {
        return this.referer;
    }

    public OperationInfo setReferer(String referer) {
        this.referer = referer;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public OperationInfo setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String getOperationConsumerId() {
        if (!Strings.isNullOrEmpty(this.apiKey) && this.apiKeyValid) {
            return "api_key:" + this.apiKey;
        }
        if (!Strings.isNullOrEmpty(this.consumerProjectId)) {
            return "project:" + this.consumerProjectId;
        }
        return null;
    }

    protected Map<String, String> getSystemLabels() {
        HashMap<String, String> labels = Maps.newHashMap();
        labels.put(SCC_USER_AGENT, "ESP");
        labels.put(SCC_SERVICE_AGENT, KnownLabels.SERVICE_AGENT);
        return labels;
    }
}

