/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.QuotaError;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;

public enum QuotaErrorInfo {
    OK(QuotaError.Code.UNSPECIFIED, 200, ""),
    RESOURCE_EXHAUSTED(QuotaError.Code.RESOURCE_EXHAUSTED, 429, "Quota allocation failed."),
    PROJECT_SUSPENDED(QuotaError.Code.PROJECT_SUSPENDED, 403, "Project suspended."),
    SERVICE_NOT_ENABLED(QuotaError.Code.SERVICE_NOT_ENABLED, 403, "API {service_name} is not available for the project."),
    BILLING_NOT_ACTIVE(QuotaError.Code.BILLING_NOT_ACTIVE, 403, "API {service_name} has billing disabled. Please enable it."),
    PROJECT_DELETED(QuotaError.Code.PROJECT_DELETED, 400, "Client project not valid. Please pass a valid project."),
    PROJECT_INVALID(QuotaError.Code.PROJECT_INVALID, 400, "Client project not valid. Please pass a valid project."),
    IP_ADDRESS_BLOCKED(QuotaError.Code.IP_ADDRESS_BLOCKED, 403, "IP address blocked."),
    REFERER_BLOCKED(QuotaError.Code.REFERER_BLOCKED, 403, "Referer blocked."),
    CLIENT_APP_BLOCKED(QuotaError.Code.CLIENT_APP_BLOCKED, 403, "Client app blocked."),
    API_KEY_INVALID(QuotaError.Code.API_KEY_INVALID, 400, "API key not valid. Please pass a valid API key."),
    API_KEY_EXPIRED(QuotaError.Code.API_KEY_EXPIRED, 400, "API key expired. Please renew the API key."),
    PROJECT_STATUS_UNAVAILABLE(QuotaError.Code.PROJECT_STATUS_UNAVAILABLE, 200, ""),
    SERVICE_STATUS_UNAVAILABLE(QuotaError.Code.SERVICE_STATUS_UNAVAILABLE, 200, ""),
    BILLING_STATUS_UNAVAILABLE(QuotaError.Code.BILLING_STATUS_UNAVAILABLE, 200, ""),
    QUOTA_SYSTEM_UNAVAILABLE(QuotaError.Code.QUOTA_SYSTEM_UNAVAILABLE, 200, ""),
    UNKNOWN(QuotaError.Code.UNRECOGNIZED, 500, "Request blocked due to unsupported block reason {detail}");

    private final QuotaError.Code code;
    private final int httpCode;
    private final String message;
    private static final Map<QuotaError.Code, QuotaErrorInfo> CONVERSION;

    private QuotaErrorInfo(QuotaError.Code code, int httpCode, String message) {
        this.code = code;
        this.httpCode = httpCode;
        this.message = message;
    }

    public String fullMessage(@Nullable String projectId, @Nullable String detail) {
        projectId = Strings.nullToEmpty(projectId);
        detail = Strings.nullToEmpty(detail);
        return this.message.replaceAll("\\{project_id\\}", projectId).replaceAll("\\{detail\\}", detail);
    }

    public String getMessage() {
        return this.message;
    }

    public int getHttpCode() {
        return this.httpCode;
    }

    public boolean isReallyError() {
        return this.httpCode != 200;
    }

    public static QuotaErrorInfo convert(@Nullable AllocateQuotaResponse response) {
        if (response == null) {
            return SERVICE_STATUS_UNAVAILABLE;
        }
        if (response.getAllocateErrorsCount() == 0) {
            return OK;
        }
        QuotaErrorInfo result = CONVERSION.get(response.getAllocateErrors(0).getCode());
        if (result == null) {
            return UNKNOWN;
        }
        return result;
    }

    static {
        CONVERSION = Maps.newHashMap();
        for (QuotaErrorInfo i : QuotaErrorInfo.values()) {
            if (i.code == QuotaError.Code.UNRECOGNIZED) continue;
            CONVERSION.put(i.code, i);
        }
    }
}

