/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.OperationInfo;
import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValue;
import endpoints.repackaged.com.google.api.servicecontrol.v1.MetricValueSet;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.api.servicecontrol.v1.QuotaOperation;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import java.util.Map;

public class QuotaRequestInfo
extends OperationInfo {
    private Map<String, Long> metricCosts;
    private String configId;
    private String clientIp;

    public QuotaRequestInfo() {
        this.metricCosts = ImmutableMap.of();
    }

    public QuotaRequestInfo(OperationInfo o) {
        this.setApiKey(o.getApiKey());
        this.setApiKeyValid(o.isApiKeyValid());
        this.setConsumerProjectId(o.getConsumerProjectId());
        this.setOperationId(o.getOperationId());
        this.setOperationName(o.getOperationName());
        this.setReferer(o.getReferer());
        this.setServiceName(o.getServiceName());
    }

    public QuotaRequestInfo setMetricCosts(Map<String, Long> metricCosts) {
        this.metricCosts = metricCosts;
        return this;
    }

    public Map<String, Long> getMetricCosts() {
        return this.metricCosts;
    }

    public QuotaRequestInfo setConfigId(String configId) {
        this.configId = configId;
        return this;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public QuotaRequestInfo setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public AllocateQuotaRequest asQuotaRequest(Clock clock) {
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getServiceName()), "a service name must be set");
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getOperationId()), "an operation ID must be set");
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getOperationName()), "an operation name must be set");
        Operation.Builder b = super.asOperation(clock).toBuilder();
        b.putAllLabels(this.getSystemLabels());
        QuotaOperation.Builder opBuilder = QuotaOperation.newBuilder().setOperationId(this.getOperationId()).setMethodName(this.getOperationName()).setConsumerId(this.getOperationConsumerId()).setQuotaMode(QuotaOperation.QuotaMode.BEST_EFFORT).putAllLabels(this.getSystemLabels());
        for (Map.Entry<String, Long> entry : this.metricCosts.entrySet()) {
            long cost = entry.getValue();
            opBuilder.addQuotaMetrics(MetricValueSet.newBuilder().setMetricName(entry.getKey()).addMetricValues(MetricValue.newBuilder().setInt64Value(cost <= 0L ? 1L : cost)));
        }
        AllocateQuotaRequest.Builder builder = AllocateQuotaRequest.newBuilder().setServiceName(this.getServiceName()).setAllocateOperation(opBuilder);
        if (this.configId != null) {
            builder.setServiceConfigId(this.configId);
        }
        return builder.build();
    }

    @Override
    protected Map<String, String> getSystemLabels() {
        Map<String, String> labels = super.getSystemLabels();
        if (!Strings.isNullOrEmpty(this.getClientIp())) {
            labels.put("servicecontrol.googleapis.com/caller_ip", this.getClientIp());
        }
        if (!Strings.isNullOrEmpty(this.getReferer())) {
            labels.put("servicecontrol.googleapis.com/referer", this.getReferer());
        }
        return labels;
    }
}

