/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.KnownLabels;
import com.google.api.control.model.KnownMetrics;
import com.google.api.control.model.OperationInfo;
import com.google.api.control.model.ReportingRule;
import com.google.api.control.model.Timestamps;
import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.com.google.api.servicecontrol.v1.LogEntry;
import endpoints.repackaged.com.google.api.servicecontrol.v1.Operation;
import endpoints.repackaged.com.google.api.servicecontrol.v1.ReportRequest;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.google.logging.type.LogSeverity;
import endpoints.repackaged.google.protobuf.Struct;
import endpoints.repackaged.google.protobuf.Value;
import java.util.HashMap;

public class ReportRequestInfo
extends OperationInfo {
    private String apiName;
    private String apiMethod;
    private String apiVersion;
    private String authIssuer;
    private String authAudience;
    private long backendTimeMillis;
    private ErrorCause errorCause;
    private String location;
    private String logMessage;
    private String method;
    private long overheadTimeMillis;
    private ReportedPlatforms platform;
    private String producerProjectId;
    private ReportedProtocols protocol;
    private long requestSize;
    private long requestTimeMillis;
    private int responseCode;
    private long responseSize;
    private String url;
    private long consumerProjectNumber;

    public ReportRequestInfo() {
    }

    public ReportRequestInfo(OperationInfo o) {
        this.setApiKey(o.getApiKey());
        this.setApiKeyValid(o.isApiKeyValid());
        this.setConsumerProjectId(o.getConsumerProjectId());
        this.setOperationId(o.getOperationId());
        this.setOperationName(o.getOperationName());
        this.setReferer(o.getReferer());
        this.setServiceName(o.getServiceName());
        this.setErrorCause(ErrorCause.internal);
    }

    public ReportRequest asReportRequest(ReportingRule rules, Clock clock) {
        Preconditions.checkState(!Strings.isNullOrEmpty(this.getServiceName()), "a service name must be set");
        Operation.Builder o = this.asOperation(clock).toBuilder();
        if (!Strings.isNullOrEmpty(o.getOperationId()) && !Strings.isNullOrEmpty(o.getOperationName())) {
            KnownMetrics[] metrics;
            HashMap<String, String> addedLabels = Maps.newHashMap();
            for (KnownLabels l : rules.getLabels()) {
                l.performUpdate(this, addedLabels);
            }
            if (!o.getLabelsMap().containsKey(KnownLabels.SCC_PLATFORM.getName())) {
                KnownLabels.SCC_PLATFORM.performUpdate(this, addedLabels);
            }
            o.putAllLabels(this.getSystemLabels());
            o.putAllLabels(addedLabels);
            for (KnownMetrics m : metrics = rules.getMetrics()) {
                m.performUpdate(this, o);
            }
        }
        String[] logs = rules.getLogs();
        long timestampMillis = clock.currentTimeMillis();
        for (String l : logs) {
            o.addLogEntries(this.asLogEntry(l, timestampMillis));
        }
        return ReportRequest.newBuilder().addOperations(o).setServiceName(this.getServiceName()).build();
    }

    public LogEntry.Builder asLogEntry(String name, long timestampMillis) {
        Value.Builder vb = Value.newBuilder();
        HashMap<String, Value> values = Maps.newHashMap();
        values.put("http_response_code", vb.setNumberValue(this.getResponseCode()).build());
        values.put("timestamp", vb.setNumberValue(timestampMillis).build());
        if (this.getRequestSize() > 0L) {
            values.put("request_size", vb.setNumberValue(this.getRequestSize()).build());
        }
        if (this.getResponseSize() > 0L) {
            values.put("response_size", vb.setNumberValue(this.getResponseSize()).build());
        }
        if (!Strings.isNullOrEmpty(this.getMethod())) {
            values.put("http_method", vb.setStringValue(this.getMethod()).build());
        }
        if (!Strings.isNullOrEmpty(this.getApiName())) {
            values.put("api_name", vb.setStringValue(this.getApiName()).build());
        }
        if (!Strings.isNullOrEmpty(this.getApiMethod())) {
            values.put("api_method", vb.setStringValue(this.getApiMethod()).build());
        }
        if (!Strings.isNullOrEmpty(this.getApiKey())) {
            values.put("api_key", vb.setStringValue(this.getApiKey()).build());
        }
        if (!Strings.isNullOrEmpty(this.getProducerProjectId())) {
            values.put("producer_project_id", vb.setStringValue(this.getProducerProjectId()).build());
        }
        if (!Strings.isNullOrEmpty(this.getReferer())) {
            values.put("referer", vb.setStringValue(this.getReferer()).build());
        }
        if (!Strings.isNullOrEmpty(this.getLocation())) {
            values.put("location", vb.setStringValue(this.getLocation()).build());
        }
        if (!Strings.isNullOrEmpty(this.getLogMessage())) {
            values.put("log_message", vb.setStringValue(this.getLogMessage()).build());
        }
        if (!Strings.isNullOrEmpty(this.getUrl())) {
            values.put("url", vb.setStringValue(this.getUrl()).build());
        }
        LogSeverity severity = LogSeverity.INFO;
        if (this.getResponseCode() >= 400) {
            values.put("error_cause", vb.setStringValue(this.getErrorCause().name()).build());
            severity = LogSeverity.ERROR;
        }
        Struct.Builder theStruct = Struct.newBuilder().putAllFields(values);
        return LogEntry.newBuilder().setTimestamp(Timestamps.fromEpoch(timestampMillis)).setStructPayload(theStruct).setName(name).setSeverity(severity);
    }

    public String getApiName() {
        return this.apiName;
    }

    public ReportRequestInfo setApiName(String apiName) {
        this.apiName = apiName;
        return this;
    }

    public String getApiMethod() {
        return this.apiMethod;
    }

    public ReportRequestInfo setApiMethod(String apiMethod) {
        this.apiMethod = apiMethod;
        return this;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public ReportRequestInfo setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getAuthIssuer() {
        return this.authIssuer;
    }

    public ReportRequestInfo setAuthIssuer(String authIssuer) {
        this.authIssuer = authIssuer;
        return this;
    }

    public String getAuthAudience() {
        return this.authAudience;
    }

    public ReportRequestInfo setAuthAudience(String authAudience) {
        this.authAudience = authAudience;
        return this;
    }

    public long getBackendTimeMillis() {
        return this.backendTimeMillis;
    }

    public ReportRequestInfo setBackendTimeMillis(long backendTimeMillis) {
        this.backendTimeMillis = backendTimeMillis;
        return this;
    }

    public ErrorCause getErrorCause() {
        return this.errorCause;
    }

    public ReportRequestInfo setErrorCause(ErrorCause errorCause) {
        this.errorCause = errorCause;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public ReportRequestInfo setLocation(String location) {
        this.location = location;
        return this;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public ReportRequestInfo setLogMessage(String logMessage) {
        this.logMessage = logMessage;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public ReportRequestInfo setMethod(String method) {
        this.method = method;
        return this;
    }

    public long getOverheadTimeMillis() {
        return this.overheadTimeMillis;
    }

    public ReportRequestInfo setOverheadTimeMillis(long overheadTimeMillis) {
        this.overheadTimeMillis = overheadTimeMillis;
        return this;
    }

    public ReportedPlatforms getPlatform() {
        return this.platform;
    }

    public ReportRequestInfo setPlatform(ReportedPlatforms platform) {
        this.platform = platform;
        return this;
    }

    public String getProducerProjectId() {
        return this.producerProjectId;
    }

    public ReportRequestInfo setProducerProjectId(String producerProjectId) {
        this.producerProjectId = producerProjectId;
        return this;
    }

    public ReportedProtocols getProtocol() {
        return this.protocol;
    }

    public ReportRequestInfo setProtocol(ReportedProtocols protocol) {
        this.protocol = protocol;
        return this;
    }

    public long getRequestSize() {
        return this.requestSize;
    }

    public ReportRequestInfo setRequestSize(long requestSize) {
        this.requestSize = requestSize;
        return this;
    }

    public long getRequestTimeMillis() {
        return this.requestTimeMillis;
    }

    public ReportRequestInfo setRequestTimeMillis(long requestTimeMillis) {
        this.requestTimeMillis = requestTimeMillis;
        return this;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public ReportRequestInfo setResponseCode(int responseCode) {
        this.responseCode = responseCode != 0 ? responseCode : 200;
        return this;
    }

    public long getResponseSize() {
        return this.responseSize;
    }

    public ReportRequestInfo setResponseSize(long responseSize) {
        this.responseSize = responseSize;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public ReportRequestInfo setUrl(String url) {
        this.url = url;
        return this;
    }

    public long getConsumerProjectNumber() {
        return this.consumerProjectNumber;
    }

    public ReportRequestInfo setConsumerProjectNumber(long consumerProjectNumber) {
        this.consumerProjectNumber = consumerProjectNumber;
        return this;
    }

    public static enum ErrorCause {
        internal,
        application,
        auth,
        service_control;

    }

    public static enum ReportedProtocols {
        UNKNOWN,
        HTTP,
        HTTP2,
        GRPC;

    }

    public static enum ReportedPlatforms {
        UNKNOWN("Unknown"),
        GAE_STANDARD("GAE Standard"),
        GAE_FLEX("GAE Flex"),
        GCE("GCE"),
        GKE("GKE"),
        DEVELOPMENT("GAE Dev Server");

        private final String name;

        private ReportedPlatforms(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

