/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import com.google.api.control.model.KnownLabels;
import com.google.api.control.model.KnownMetrics;
import endpoints.repackaged.com.google.api.LabelDescriptor;
import endpoints.repackaged.com.google.api.LogDescriptor;
import endpoints.repackaged.com.google.api.Logging;
import endpoints.repackaged.com.google.api.MetricDescriptor;
import endpoints.repackaged.com.google.api.MonitoredResourceDescriptor;
import endpoints.repackaged.com.google.api.Monitoring;
import endpoints.repackaged.com.google.api.Service;
import endpoints.repackaged.com.google.common.collect.Maps;
import endpoints.repackaged.com.google.common.collect.Sets;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import endpoints.repackaged.com.google.common.flogger.LazyArg;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ReportingRule {
    private static final FluentLogger log = FluentLogger.forEnclosingClass();
    private static final MetricTest KNOWN_METRICS = new MetricTest(){

        @Override
        public boolean isSupported(MetricDescriptor m) {
            return KnownMetrics.isSupported(m);
        }
    };
    private static final LabelTest KNOWN_LABELS = new LabelTest(){

        @Override
        public boolean isSupported(LabelDescriptor l) {
            return KnownLabels.isSupported(l);
        }
    };
    private final String[] logs;
    private final KnownMetrics[] metrics;
    private final KnownLabels[] labels;

    public static ReportingRule fromService(Service s) {
        return ReportingRule.fromService(s, KNOWN_METRICS, KNOWN_LABELS);
    }

    public static ReportingRule fromKnownInputs(final @Nullable String[] logs, @Nullable Set<String> metricNames, @Nullable Set<String> labelNames) {
        ((FluentLogger.Api)log.atFine()).log("creating rule from log names %s, metric names %s, labelNames %s", new LazyArg<String>(){

            @Override
            public String evaluate() {
                return Arrays.toString(logs);
            }
        }, metricNames, labelNames);
        HashMap<String, KnownMetrics> namedRuleMetrics = Maps.newHashMap();
        if (metricNames != null) {
            for (KnownMetrics m : KnownMetrics.values()) {
                if (m.getUpdater() == null || !metricNames.contains(m.getName())) continue;
                ((FluentLogger.Api)log.atFine()).log("Adding metric named '%s' to the rule", m.getName());
                namedRuleMetrics.put(m.getName(), m);
            }
        }
        HashMap<String, KnownLabels> namedRuleLabels = Maps.newHashMap();
        if (labelNames != null) {
            for (KnownLabels k : KnownLabels.values()) {
                if (k.getUpdater() == null || !labelNames.contains(k.getName())) continue;
                ((FluentLogger.Api)log.atFine()).log("Adding label named '%s' to the rule", k.getName());
                namedRuleLabels.put(k.getName(), k);
            }
        }
        return new ReportingRule(logs, namedRuleMetrics.values().toArray(new KnownMetrics[namedRuleMetrics.size()]), namedRuleLabels.values().toArray(new KnownLabels[namedRuleLabels.size()]));
    }

    private static ReportingRule fromService(Service s, MetricTest checkMetrics, LabelTest checkLabels) {
        List<MonitoredResourceDescriptor> resourceDescs = s.getMonitoredResourcesList();
        HashMap<String, LabelDescriptor> labels = Maps.newHashMap();
        Set<Object> logs = Sets.newHashSet();
        if (s.hasLogging()) {
            List<Logging.LoggingDestination> producers = s.getLogging().getProducerDestinationsList();
            logs = ReportingRule.addLoggingDestinations(producers, resourceDescs, s.getLogsList(), labels, checkLabels);
        }
        HashSet<String> metrics = Sets.newHashSet();
        if (s.hasMonitoring()) {
            Monitoring monitoring = s.getMonitoring();
            ReportingRule.addMonitoringDestinations(monitoring.getConsumerDestinationsList(), resourceDescs, s.getMetricsList(), metrics, checkMetrics, labels, checkLabels);
            ReportingRule.addMonitoringDestinations(monitoring.getProducerDestinationsList(), resourceDescs, s.getMetricsList(), metrics, checkMetrics, labels, checkLabels);
        }
        return ReportingRule.fromKnownInputs(logs.toArray(new String[logs.size()]), metrics, labels.keySet());
    }

    private ReportingRule(@Nullable String[] logs, @Nullable KnownMetrics[] metrics, @Nullable KnownLabels[] labels) {
        this.logs = logs == null ? new String[0] : logs;
        this.metrics = metrics == null ? new KnownMetrics[0] : metrics;
        this.labels = labels == null ? new KnownLabels[0] : labels;
    }

    public String[] getLogs() {
        return this.logs;
    }

    public KnownMetrics[] getMetrics() {
        return this.metrics;
    }

    public KnownLabels[] getLabels() {
        return this.labels;
    }

    private static Set<String> addLoggingDestinations(List<Logging.LoggingDestination> destinations, List<MonitoredResourceDescriptor> resourceDescs, List<LogDescriptor> logDescs, Map<String, LabelDescriptor> labels, LabelTest checkLabels) {
        HashSet<String> logs = Sets.newHashSet();
        for (Logging.LoggingDestination d : destinations) {
            if (!ReportingRule.addLabelsForAMonitoredResource(resourceDescs, d.getMonitoredResource(), labels, checkLabels)) continue;
            for (String name : d.getLogsList()) {
                if (!ReportingRule.addLabelsForALog(logDescs, name, labels, checkLabels)) continue;
                logs.add(name);
            }
        }
        return logs;
    }

    private static void addMonitoringDestinations(List<Monitoring.MonitoringDestination> destinations, List<MonitoredResourceDescriptor> resourceDescs, List<MetricDescriptor> metricDests, Set<String> metrics, MetricTest checkMetric, Map<String, LabelDescriptor> labels, LabelTest checkLabel) {
        for (Monitoring.MonitoringDestination d : destinations) {
            if (!ReportingRule.addLabelsForAMonitoredResource(resourceDescs, d.getMonitoredResource(), labels, checkLabel)) continue;
            for (String metric : d.getMetricsList()) {
                MetricDescriptor metricDest = ReportingRule.findMetricDescriptor(metricDests, metric, checkMetric);
                if (metricDest == null || !ReportingRule.addLabelsFromDescriptors(metricDest.getLabelsList(), labels, checkLabel)) continue;
                metrics.add(metric);
            }
        }
    }

    private static boolean addLabelsFromDescriptors(List<LabelDescriptor> labelDescs, Map<String, LabelDescriptor> labels, LabelTest check) {
        for (LabelDescriptor d : labelDescs) {
            LabelDescriptor existing = labels.get(d.getKey());
            if (existing == null || existing.getValueType().equals(d.getValueType())) continue;
            ((FluentLogger.Api)log.atWarning()).log("halted label scan: conflicting label in %s", d.getKey());
            return false;
        }
        for (LabelDescriptor d : labelDescs) {
            if (!check.isSupported(d)) continue;
            labels.put(d.getKey(), d);
        }
        return true;
    }

    private static boolean addLabelsForALog(List<LogDescriptor> logDescs, String name, Map<String, LabelDescriptor> labels, LabelTest check) {
        for (LogDescriptor d : logDescs) {
            if (!d.getName().equals(name)) continue;
            return ReportingRule.addLabelsFromDescriptors(d.getLabelsList(), labels, check);
        }
        ((FluentLogger.Api)log.atWarning()).log("bad log label scan: log %s was not found", name);
        return false;
    }

    private static boolean addLabelsForAMonitoredResource(List<MonitoredResourceDescriptor> resourceDescs, String resourceType, Map<String, LabelDescriptor> labels, LabelTest check) {
        for (MonitoredResourceDescriptor d : resourceDescs) {
            if (!d.getType().equals(resourceType)) continue;
            return ReportingRule.addLabelsFromDescriptors(d.getLabelsList(), labels, check);
        }
        ((FluentLogger.Api)log.atWarning()).log("bad monitored resource label scan: resource %s was not found", resourceType);
        return false;
    }

    private static MetricDescriptor findMetricDescriptor(List<MetricDescriptor> metricDests, String metric, MetricTest check) {
        for (MetricDescriptor d : metricDests) {
            if (!d.getName().equals(metric) || !check.isSupported(d)) continue;
            return d;
        }
        return null;
    }

    public static interface LabelTest {
        public boolean isSupported(LabelDescriptor var1);
    }

    public static interface MetricTest {
        public boolean isSupported(MetricDescriptor var1);
    }
}

