/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import endpoints.repackaged.com.google.api.client.util.Clock;
import endpoints.repackaged.google.protobuf.Timestamp;
import java.util.Comparator;

public final class Timestamps {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    public static Comparator<Timestamp> COMPARATOR = new Comparator<Timestamp>(){

        @Override
        public int compare(Timestamp o1, Timestamp o2) {
            int secondsOrder = Long.compare(o1.getSeconds(), o2.getSeconds());
            if (secondsOrder != 0) {
                return secondsOrder;
            }
            return Long.compare(o1.getNanos(), o2.getNanos());
        }
    };

    private Timestamps() {
    }

    public static Timestamp now(Clock clock) {
        return Timestamps.fromEpoch(clock.currentTimeMillis());
    }

    public static Timestamp fromEpoch(long epochMillis) {
        return Timestamp.newBuilder().setNanos((int)(epochMillis % 1000L * 1000000L)).setSeconds(epochMillis / 1000L).build();
    }
}

