/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.control.model;

import endpoints.repackaged.com.google.common.annotations.Beta;
import endpoints.repackaged.com.google.common.base.Supplier;
import endpoints.repackaged.com.google.common.base.Suppliers;
import java.util.Stack;

@Beta
public class ValidationException
extends IllegalArgumentException {
    private static ThreadLocal<Stack<Supplier<String>>> contextLocal = new ThreadLocal();

    public static void pushCurrentThreadValidationContext(Supplier<String> supplier) {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack == null) {
            stack = new Stack();
            contextLocal.set(stack);
        }
        stack.push(supplier);
    }

    public static void pushCurrentThreadValidationContext(String context) {
        ValidationException.pushCurrentThreadValidationContext(Suppliers.ofInstance(context));
    }

    public static void popCurrentThreadValidationContext() {
        Stack<Supplier<String>> stack = contextLocal.get();
        if (stack != null) {
            stack.pop();
        }
    }

    public ValidationException(String format, Object ... args) {
        super(ValidationException.message(contextLocal.get(), format, args));
    }

    private static String message(Stack<Supplier<String>> context, String format, Object ... args) {
        if (context == null || context.isEmpty()) {
            return String.format(format, args);
        }
        StringBuilder result = new StringBuilder();
        for (Supplier supplier : context) {
            result.append((String)supplier.get() + ": ");
        }
        return result.toString() + String.format(format, args);
    }
}

