/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.auth;

import com.google.api.auth.Authenticator;
import com.google.api.auth.UnauthenticatedException;
import com.google.api.auth.UserInfo;
import com.google.api.control.ConfigFilter;
import com.google.api.control.model.MethodRegistry;
import com.google.api.server.spi.auth.common.User;
import com.google.api.server.spi.config.Singleton;
import endpoints.repackaged.com.google.api.Service;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Optional;
import endpoints.repackaged.com.google.common.flogger.FluentLogger;
import endpoints.repackaged.com.google.common.util.concurrent.UncheckedExecutionException;
import javax.servlet.http.HttpServletRequest;

@Singleton
public final class EspAuthenticator
implements com.google.api.server.spi.config.Authenticator {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();
    private final Authenticator authenticator;

    public EspAuthenticator() {
        this(Authenticator.create());
    }

    @VisibleForTesting
    EspAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public User authenticate(HttpServletRequest request) {
        MethodRegistry.Info methodInfo = ConfigFilter.getMethodInfo(request);
        if (methodInfo == null) {
            throw new IllegalStateException("method_info is not set in the request");
        }
        Optional<MethodRegistry.AuthInfo> authInfo = methodInfo.getAuthInfo();
        if (!authInfo.isPresent()) {
            ((FluentLogger.Api)logger.atInfo()).log("auth is not configured for this request");
            return null;
        }
        Service service = ConfigFilter.getService(request);
        if (service == null) {
            throw new IllegalStateException("service is not set in the request");
        }
        String serviceName = service.getName();
        try {
            UserInfo userInfo = this.authenticator.authenticate(request, authInfo.get(), serviceName);
            return new User(userInfo.getId(), userInfo.getEmail());
        }
        catch (UnauthenticatedException | UncheckedExecutionException exception) {
            ((FluentLogger.Api)((FluentLogger.Api)logger.atWarning()).withCause(exception)).log("Authentication failed");
            return null;
        }
    }
}

