/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.client.extensions.servlet.auth;

import endpoints.repackaged.com.google.api.client.extensions.auth.helpers.Credential;
import endpoints.repackaged.com.google.api.client.extensions.auth.helpers.ThreeLeggedFlow;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.json.JsonFactory;
import endpoints.repackaged.com.google.api.client.util.Beta;
import java.io.IOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Beta
public abstract class AbstractFlowUserServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final HttpTransport httpTransport = this.newHttpTransportInstance();
    private final JsonFactory jsonFactory = this.newJsonFactoryInstance();
    private static final String AUTH_CREDENTIAL = "endpoints.repackaged.com.google.api.client.extensions.servlet.auth.credential";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        block8: {
            PersistenceManager pm = this.getPersistenceManagerFactory().getPersistenceManager();
            String userId = this.getUserId();
            ThreeLeggedFlow oauthFlow = this.newFlow(userId);
            oauthFlow.setJsonFactory(this.getJsonFactory());
            oauthFlow.setHttpTransport(this.getHttpTransport());
            try {
                Credential cred = oauthFlow.loadCredential(pm);
                if (cred != null && cred.isInvalid()) {
                    pm.deletePersistent(cred);
                    cred = null;
                }
                if (cred != null) {
                    req.setAttribute(AUTH_CREDENTIAL, cred);
                    try {
                        super.service(req, resp);
                        break block8;
                    }
                    catch (IOException e) {
                        if (cred.isInvalid()) {
                            pm.deletePersistent(cred);
                            this.startAuthFlow(resp, pm, oauthFlow);
                            break block8;
                        }
                        throw e;
                    }
                }
                this.startAuthFlow(resp, pm, oauthFlow);
            }
            finally {
                pm.close();
            }
        }
    }

    private void startAuthFlow(HttpServletResponse resp, PersistenceManager pm, ThreeLeggedFlow oauthFlow) throws IOException {
        pm.makePersistent(oauthFlow);
        String authorizationUrl = oauthFlow.getAuthorizationUrl();
        resp.sendRedirect(authorizationUrl);
    }

    protected Credential getCredential(HttpServletRequest req) {
        Credential cred = (Credential)req.getAttribute(AUTH_CREDENTIAL);
        return cred;
    }

    protected final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    protected final HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    protected abstract PersistenceManagerFactory getPersistenceManagerFactory();

    protected abstract ThreeLeggedFlow newFlow(String var1) throws IOException;

    protected abstract HttpTransport newHttpTransportInstance();

    protected abstract JsonFactory newJsonFactoryInstance();

    protected abstract String getUserId();
}

