/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.config;

import endpoints.repackaged.com.google.api.Service;
import endpoints.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import endpoints.repackaged.com.google.api.client.http.HttpRequest;
import endpoints.repackaged.com.google.api.client.http.HttpRequestInitializer;
import endpoints.repackaged.com.google.api.client.http.HttpResponse;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import endpoints.repackaged.com.google.api.client.json.JsonFactory;
import endpoints.repackaged.com.google.api.client.json.jackson2.JacksonFactory;
import endpoints.repackaged.com.google.api.config.Environment;
import endpoints.repackaged.com.google.api.config.ServiceConfigException;
import endpoints.repackaged.com.google.api.services.servicemanagement.ServiceManagement;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.ListServiceConfigsResponse;
import endpoints.repackaged.com.google.common.annotations.VisibleForTesting;
import endpoints.repackaged.com.google.common.base.Joiner;
import endpoints.repackaged.com.google.common.base.Preconditions;
import endpoints.repackaged.com.google.common.base.Strings;
import endpoints.repackaged.com.google.common.base.Supplier;
import endpoints.repackaged.com.google.common.collect.ImmutableList;
import endpoints.repackaged.com.google.common.collect.ImmutableMap;
import endpoints.repackaged.google.protobuf.Message;
import endpoints.repackaged.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.Nullable;

public final class ServiceConfigSupplier
implements Supplier<Service> {
    private static final String SERVICE_NAME_KEY = "ENDPOINTS_SERVICE_NAME";
    private static final String SERVICE_VERSION_KEY = "ENDPOINTS_SERVICE_VERSION";
    private static final ImmutableMap<Integer, String> ERROR_CODE_DETAILS = ImmutableMap.builder().put(403, "This may occur if the App Engine service account has been deleted or does not have correct permissions. Visit https://goo.gl/UEKik4 and verify that the App Engine default service account has either the Editor or Service Controller role.").put(404, "The service config name and config id could not be found. Double check that filter initialization parameters endpoints.projectId and endpoints.serviceName are correctly set. See https://goo.gl/yp8QUN for details.").put(429, "Too many requests are being made to fetch the service config. Check to see if instances are crashing prematurely. If not, you may need to increase your Google Service Management API quota. See https://goo.gl/JjBQMu to manage quota.").build();
    private static final List<String> SCOPES = ImmutableList.of("https://www.googleapis.com/auth/cloud-platform");
    private static final String FIELD_MASKS = Joiner.on(',').join("authentication", "http", "id", "logging", "logs", "metrics", "monitored_resources", "monitoring", "name", "producer_project_id", "quota", "system_parameters", "usage");
    private final Environment environment;
    private final ServiceManagement serviceManagement;

    @VisibleForTesting
    ServiceConfigSupplier(Environment environment, HttpTransport httpTransport, JsonFactory jsonFactory, final GoogleCredential credential) {
        this.environment = environment;
        HttpRequestInitializer requestInitializer = new HttpRequestInitializer(){

            @Override
            public void initialize(HttpRequest request) throws IOException {
                request.setThrowExceptionOnExecuteError(false);
                credential.initialize(request);
            }
        };
        this.serviceManagement = new ServiceManagement.Builder(httpTransport, jsonFactory, requestInitializer).setApplicationName("Endpoints Frameworks Java").build();
    }

    @Override
    public Service get() {
        String serviceName = this.environment.getVariable(SERVICE_NAME_KEY);
        if (Strings.isNullOrEmpty(serviceName)) {
            String errorMessage = String.format("Environment variable '%s' is not set", SERVICE_NAME_KEY);
            throw new IllegalArgumentException(errorMessage);
        }
        String serviceVersion = this.environment.getVariable(SERVICE_VERSION_KEY);
        return this.fetch(serviceName, serviceVersion);
    }

    private Service fetch(String serviceName, @Nullable String serviceVersion) {
        HttpResponse httpResponse;
        Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceName), "service name must be specified");
        if (serviceVersion == null) {
            serviceVersion = this.fetchLatestServiceVersion(serviceName);
        }
        try {
            httpResponse = this.serviceManagement.services().configs().get(serviceName, serviceVersion).setFields(FIELD_MASKS).executeUnparsed();
        }
        catch (IOException exception) {
            throw new ServiceConfigException(exception);
        }
        int statusCode = httpResponse.getStatusCode();
        if (statusCode != 200) {
            String extendedMessage = ERROR_CODE_DETAILS.get(statusCode);
            String message = MessageFormat.format("Failed to fetch service config (status code {0})", statusCode);
            if (extendedMessage != null) {
                message = String.format("%s: %s", message, extendedMessage);
            }
            throw new ServiceConfigException(message);
        }
        Service service = ServiceConfigSupplier.parseHttpResponse(httpResponse);
        ServiceConfigSupplier.validateServiceConfig(service, serviceName, serviceVersion);
        return service;
    }

    private String fetchLatestServiceVersion(String serviceName) {
        try {
            ListServiceConfigsResponse response = (ListServiceConfigsResponse)this.serviceManagement.services().configs().list(serviceName).execute();
            if (response.getServiceConfigs() == null || response.getServiceConfigs().isEmpty()) {
                throw new ServiceConfigException(MessageFormat.format("Failed to fetch default config version for service ''{0}''. No versions exist!", serviceName));
            }
            return response.getServiceConfigs().get(0).getId();
        }
        catch (IOException e) {
            throw new ServiceConfigException(e);
        }
    }

    private static Service parseHttpResponse(HttpResponse httpResponse) {
        try {
            Service.Builder builder = Service.newBuilder();
            JsonFormat.parser().merge(httpResponse.parseAsString(), (Message.Builder)builder);
            return builder.build();
        }
        catch (IOException exception) {
            throw new ServiceConfigException("Failed to parse the HTTP response as service configuration", exception);
        }
    }

    private static void validateServiceConfig(Service service, String expectedServiceName, @Nullable String expectedServiceVersion) {
        String serviceName = service.getName();
        if (!expectedServiceName.equals(serviceName)) {
            throw new ServiceConfigException("Unexpected service name in service config: " + serviceName);
        }
        String serviceVersion = service.getId();
        if (expectedServiceVersion != null && !expectedServiceVersion.equals(serviceVersion)) {
            throw new ServiceConfigException("Unexpected service version in service config: " + serviceVersion);
        }
    }

    public static ServiceConfigSupplier create() {
        GoogleCredential credential;
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        try {
            credential = GoogleCredential.getApplicationDefault(httpTransport, jsonFactory).createScoped(SCOPES);
        }
        catch (IOException e) {
            throw new IllegalStateException("could not get credentials for fetching service config!");
        }
        return new ServiceConfigSupplier(new SystemEnvironment(), httpTransport, jsonFactory, credential);
    }

    private static final class SystemEnvironment
    implements Environment {
        private SystemEnvironment() {
        }

        @Override
        public String getVariable(String variableName) {
            return System.getenv(variableName);
        }
    }
}

