/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.services.servicecontrol.v1;

import endpoints.repackaged.com.google.api.client.googleapis.GoogleUtils;
import endpoints.repackaged.com.google.api.client.googleapis.services.AbstractGoogleClient;
import endpoints.repackaged.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import endpoints.repackaged.com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import endpoints.repackaged.com.google.api.client.http.HttpContent;
import endpoints.repackaged.com.google.api.client.http.HttpRequestInitializer;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.http.protobuf.ProtoHttpContent;
import endpoints.repackaged.com.google.api.client.protobuf.ProtoObjectParser;
import endpoints.repackaged.com.google.api.client.util.Key;
import endpoints.repackaged.com.google.api.client.util.ObjectParser;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.AllocateQuotaResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.CheckResponse;
import endpoints.repackaged.com.google.api.servicecontrol.v1.ReportRequest;
import endpoints.repackaged.com.google.api.servicecontrol.v1.ReportResponse;
import endpoints.repackaged.com.google.api.services.servicecontrol.v1.ServiceControlRequest;
import endpoints.repackaged.com.google.api.services.servicecontrol.v1.ServiceControlRequestInitializer;
import java.io.IOException;

public class ServiceControl
extends AbstractGoogleClient {
    private static final ObjectParser parser = new ProtoObjectParser();
    public static final String DEFAULT_ROOT_URL = "https://servicecontrol.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://servicecontrol.googleapis.com/";

    public ServiceControl(HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, httpRequestInitializer));
    }

    ServiceControl(Builder builder) {
        super(builder);
    }

    @Override
    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState(GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15, "You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0-SNAPSHOT of the Google Service Control API library.", GoogleUtils.VERSION);
    }

    public static final class Builder
    extends AbstractGoogleClient.Builder {
        public Builder(HttpTransport transport, HttpRequestInitializer httpRequestInitializer) {
            super(transport, "https://servicecontrol.googleapis.com/", ServiceControl.DEFAULT_SERVICE_PATH, parser, httpRequestInitializer);
        }

        @Override
        public ServiceControl build() {
            return new ServiceControl(this);
        }

        @Override
        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        @Override
        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        @Override
        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        @Override
        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        @Override
        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        @Override
        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        @Override
        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setServiceControlRequestInitializer(ServiceControlRequestInitializer servicecontrolRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(servicecontrolRequestInitializer);
        }

        @Override
        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Services {
        public AllocateQuota allocateQuota(String serviceName, AllocateQuotaRequest content) throws IOException {
            AllocateQuota result = new AllocateQuota(serviceName, content);
            ServiceControl.this.initialize(result);
            return result;
        }

        public Check check(String serviceName, CheckRequest content) throws IOException {
            Check result = new Check(serviceName, content);
            ServiceControl.this.initialize(result);
            return result;
        }

        public Report report(String serviceName, ReportRequest content) throws IOException {
            Report result = new Report(serviceName, content);
            ServiceControl.this.initialize(result);
            return result;
        }

        public class Report
        extends ServiceControlRequest<ReportResponse> {
            private static final String REST_PATH = "v1/services/{serviceName}:report";
            @Key
            private String serviceName;

            protected Report(String serviceName, ReportRequest content) {
                super(ServiceControl.this, "POST", REST_PATH, (HttpContent)new ProtoHttpContent(content), ReportResponse.class);
                this.serviceName = Preconditions.checkNotNull(serviceName, "Required parameter serviceName must be specified.");
            }

            public Report setAccessToken(String accessToken) {
                return (Report)super.setAccessToken(accessToken);
            }

            public Report setAlt(String alt) {
                return (Report)super.setAlt(alt);
            }

            public Report setBearerToken(String bearerToken) {
                return (Report)super.setBearerToken(bearerToken);
            }

            public Report setCallback(String callback) {
                return (Report)super.setCallback(callback);
            }

            public Report setFields(String fields) {
                return (Report)super.setFields(fields);
            }

            public Report setKey(String key) {
                return (Report)super.setKey(key);
            }

            public Report setOauthToken(String oauthToken) {
                return (Report)super.setOauthToken(oauthToken);
            }

            public Report setPp(Boolean pp) {
                return (Report)super.setPp(pp);
            }

            public Report setPrettyPrint(Boolean prettyPrint) {
                return (Report)super.setPrettyPrint(prettyPrint);
            }

            public Report setQuotaUser(String quotaUser) {
                return (Report)super.setQuotaUser(quotaUser);
            }

            public Report setUploadType(String uploadType) {
                return (Report)super.setUploadType(uploadType);
            }

            public Report setUploadProtocol(String uploadProtocol) {
                return (Report)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Report setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Report set(String parameterName, Object value) {
                return (Report)super.set(parameterName, value);
            }
        }

        public class Check
        extends ServiceControlRequest<CheckResponse> {
            private static final String REST_PATH = "v1/services/{serviceName}:check";
            @Key
            private String serviceName;

            protected Check(String serviceName, CheckRequest content) {
                super(ServiceControl.this, "POST", REST_PATH, (HttpContent)new ProtoHttpContent(content), CheckResponse.class);
                this.serviceName = Preconditions.checkNotNull(serviceName, "Required parameter serviceName must be specified.");
            }

            public Check setAccessToken(String accessToken) {
                return (Check)super.setAccessToken(accessToken);
            }

            public Check setAlt(String alt) {
                return (Check)super.setAlt(alt);
            }

            public Check setBearerToken(String bearerToken) {
                return (Check)super.setBearerToken(bearerToken);
            }

            public Check setCallback(String callback) {
                return (Check)super.setCallback(callback);
            }

            public Check setFields(String fields) {
                return (Check)super.setFields(fields);
            }

            public Check setKey(String key) {
                return (Check)super.setKey(key);
            }

            public Check setOauthToken(String oauthToken) {
                return (Check)super.setOauthToken(oauthToken);
            }

            public Check setPp(Boolean pp) {
                return (Check)super.setPp(pp);
            }

            public Check setPrettyPrint(Boolean prettyPrint) {
                return (Check)super.setPrettyPrint(prettyPrint);
            }

            public Check setQuotaUser(String quotaUser) {
                return (Check)super.setQuotaUser(quotaUser);
            }

            public Check setUploadType(String uploadType) {
                return (Check)super.setUploadType(uploadType);
            }

            public Check setUploadProtocol(String uploadProtocol) {
                return (Check)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Check setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public Check set(String parameterName, Object value) {
                return (Check)super.set(parameterName, value);
            }
        }

        public class AllocateQuota
        extends ServiceControlRequest<AllocateQuotaResponse> {
            private static final String REST_PATH = "v1/services/{serviceName}:allocateQuota";
            @Key
            private String serviceName;

            protected AllocateQuota(String serviceName, AllocateQuotaRequest content) {
                super(ServiceControl.this, "POST", REST_PATH, (HttpContent)new ProtoHttpContent(content), AllocateQuotaResponse.class);
                this.serviceName = Preconditions.checkNotNull(serviceName, "Required parameter serviceName must be specified.");
            }

            public AllocateQuota setAccessToken(String accessToken) {
                return (AllocateQuota)super.setAccessToken(accessToken);
            }

            public AllocateQuota setAlt(String alt) {
                return (AllocateQuota)super.setAlt(alt);
            }

            public AllocateQuota setBearerToken(String bearerToken) {
                return (AllocateQuota)super.setBearerToken(bearerToken);
            }

            public AllocateQuota setCallback(String callback) {
                return (AllocateQuota)super.setCallback(callback);
            }

            public AllocateQuota setFields(String fields) {
                return (AllocateQuota)super.setFields(fields);
            }

            public AllocateQuota setKey(String key) {
                return (AllocateQuota)super.setKey(key);
            }

            public AllocateQuota setOauthToken(String oauthToken) {
                return (AllocateQuota)super.setOauthToken(oauthToken);
            }

            public AllocateQuota setPp(Boolean pp) {
                return (AllocateQuota)super.setPp(pp);
            }

            public AllocateQuota setPrettyPrint(Boolean prettyPrint) {
                return (AllocateQuota)super.setPrettyPrint(prettyPrint);
            }

            public AllocateQuota setQuotaUser(String quotaUser) {
                return (AllocateQuota)super.setQuotaUser(quotaUser);
            }

            public AllocateQuota setUploadType(String uploadType) {
                return (AllocateQuota)super.setUploadType(uploadType);
            }

            public AllocateQuota setUploadProtocol(String uploadProtocol) {
                return (AllocateQuota)super.setUploadProtocol(uploadProtocol);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public AllocateQuota setServiceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Override
            public AllocateQuota set(String parameterName, Object value) {
                return (AllocateQuota)super.set(parameterName, value);
            }
        }
    }
}

