/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.api.services.servicemanagement;

import endpoints.repackaged.com.google.api.client.googleapis.GoogleUtils;
import endpoints.repackaged.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import endpoints.repackaged.com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import endpoints.repackaged.com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import endpoints.repackaged.com.google.api.client.http.HttpRequest;
import endpoints.repackaged.com.google.api.client.http.HttpRequestInitializer;
import endpoints.repackaged.com.google.api.client.http.HttpResponse;
import endpoints.repackaged.com.google.api.client.http.HttpTransport;
import endpoints.repackaged.com.google.api.client.json.JsonFactory;
import endpoints.repackaged.com.google.api.client.util.Key;
import endpoints.repackaged.com.google.api.client.util.Preconditions;
import endpoints.repackaged.com.google.api.services.servicemanagement.ServiceManagementRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.ServiceManagementRequestInitializer;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.DisableServiceRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.EnableServiceRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.GenerateConfigReportRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.GenerateConfigReportResponse;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.GetIamPolicyRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.ListServiceConfigsResponse;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.ListServiceRolloutsResponse;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.ListServicesResponse;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.ManagedService;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.Operation;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.Policy;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.Rollout;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.Service;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.SetIamPolicyRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.SubmitConfigSourceRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.TestIamPermissionsRequest;
import endpoints.repackaged.com.google.api.services.servicemanagement.model.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagement
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://servicemanagement.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://servicemanagement.googleapis.com/";

    public ServiceManagement(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    ServiceManagement(Builder builder) {
        super(builder);
    }

    @Override
    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Operations operations() {
        return new Operations();
    }

    public Services services() {
        return new Services();
    }

    static {
        Preconditions.checkState(GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15, "You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0 of the Google Service Management API library.", GoogleUtils.VERSION);
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://servicemanagement.googleapis.com/", ServiceManagement.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public ServiceManagement build() {
            return new ServiceManagement(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setServiceManagementRequestInitializer(ServiceManagementRequestInitializer serviceManagementRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(serviceManagementRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Services {
        public Create create(ManagedService managedService) throws IOException {
            Create create = new Create(managedService);
            ServiceManagement.this.initialize(create);
            return create;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            ServiceManagement.this.initialize(delete);
            return delete;
        }

        public Disable disable(String string, DisableServiceRequest disableServiceRequest) throws IOException {
            Disable disable = new Disable(string, disableServiceRequest);
            ServiceManagement.this.initialize(disable);
            return disable;
        }

        public Enable enable(String string, EnableServiceRequest enableServiceRequest) throws IOException {
            Enable enable = new Enable(string, enableServiceRequest);
            ServiceManagement.this.initialize(enable);
            return enable;
        }

        public GenerateConfigReport generateConfigReport(GenerateConfigReportRequest generateConfigReportRequest) throws IOException {
            GenerateConfigReport generateConfigReport = new GenerateConfigReport(generateConfigReportRequest);
            ServiceManagement.this.initialize(generateConfigReport);
            return generateConfigReport;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            ServiceManagement.this.initialize(get);
            return get;
        }

        public GetConfig getConfig(String string) throws IOException {
            GetConfig getConfig = new GetConfig(string);
            ServiceManagement.this.initialize(getConfig);
            return getConfig;
        }

        public GetIamPolicy getIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) throws IOException {
            GetIamPolicy getIamPolicy = new GetIamPolicy(string, getIamPolicyRequest);
            ServiceManagement.this.initialize(getIamPolicy);
            return getIamPolicy;
        }

        public List list() throws IOException {
            List list = new List();
            ServiceManagement.this.initialize(list);
            return list;
        }

        public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
            SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
            ServiceManagement.this.initialize(setIamPolicy);
            return setIamPolicy;
        }

        public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
            TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
            ServiceManagement.this.initialize(testIamPermissions);
            return testIamPermissions;
        }

        public Undelete undelete(String string) throws IOException {
            Undelete undelete = new Undelete(string);
            ServiceManagement.this.initialize(undelete);
            return undelete;
        }

        public Configs configs() {
            return new Configs();
        }

        public Rollouts rollouts() {
            return new Rollouts();
        }

        public class Rollouts {
            public Create create(String string, Rollout rollout) throws IOException {
                Create create = new Create(string, rollout);
                ServiceManagement.this.initialize(create);
                return create;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                ServiceManagement.this.initialize(get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                ServiceManagement.this.initialize(list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ServiceManagementRequest<ListServiceRolloutsResponse> {
                private static final String REST_PATH = "v1/services/{serviceName}/rollouts";
                @Key
                private String serviceName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(ServiceManagement.this, "GET", REST_PATH, (Object)null, ListServiceRolloutsResponse.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public List setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ServiceManagementRequest<Rollout> {
                private static final String REST_PATH = "v1/services/{serviceName}/rollouts/{rolloutId}";
                @Key
                private String serviceName;
                @Key
                private String rolloutId;

                protected Get(String string, String string2) {
                    super(ServiceManagement.this, "GET", REST_PATH, (Object)null, Rollout.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                    this.rolloutId = Preconditions.checkNotNull(string2, "Required parameter rolloutId must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Get setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                public String getRolloutId() {
                    return this.rolloutId;
                }

                public Get setRolloutId(String string) {
                    this.rolloutId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ServiceManagementRequest<Operation> {
                private static final String REST_PATH = "v1/services/{serviceName}/rollouts";
                @Key
                private String serviceName;

                protected Create(String string, Rollout rollout) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)rollout, Operation.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Create setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Configs {
            public Create create(String string, Service service) throws IOException {
                Create create = new Create(string, service);
                ServiceManagement.this.initialize(create);
                return create;
            }

            public Get get(String string, String string2) throws IOException {
                Get get = new Get(string, string2);
                ServiceManagement.this.initialize(get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                ServiceManagement.this.initialize(list);
                return list;
            }

            public Submit submit(String string, SubmitConfigSourceRequest submitConfigSourceRequest) throws IOException {
                Submit submit = new Submit(string, submitConfigSourceRequest);
                ServiceManagement.this.initialize(submit);
                return submit;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Submit
            extends ServiceManagementRequest<Operation> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs:submit";
                @Key
                private String serviceName;

                protected Submit(String string, SubmitConfigSourceRequest submitConfigSourceRequest) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)submitConfigSourceRequest, Operation.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                }

                public Submit set$Xgafv(String string) {
                    return (Submit)super.set$Xgafv(string);
                }

                public Submit setAccessToken(String string) {
                    return (Submit)super.setAccessToken(string);
                }

                public Submit setAlt(String string) {
                    return (Submit)super.setAlt(string);
                }

                public Submit setBearerToken(String string) {
                    return (Submit)super.setBearerToken(string);
                }

                public Submit setCallback(String string) {
                    return (Submit)super.setCallback(string);
                }

                public Submit setFields(String string) {
                    return (Submit)super.setFields(string);
                }

                public Submit setKey(String string) {
                    return (Submit)super.setKey(string);
                }

                public Submit setOauthToken(String string) {
                    return (Submit)super.setOauthToken(string);
                }

                public Submit setPp(Boolean bl) {
                    return (Submit)super.setPp(bl);
                }

                public Submit setPrettyPrint(Boolean bl) {
                    return (Submit)super.setPrettyPrint(bl);
                }

                public Submit setQuotaUser(String string) {
                    return (Submit)super.setQuotaUser(string);
                }

                public Submit setUploadType(String string) {
                    return (Submit)super.setUploadType(string);
                }

                public Submit setUploadProtocol(String string) {
                    return (Submit)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Submit setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                @Override
                public Submit set(String string, Object object) {
                    return (Submit)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends ServiceManagementRequest<ListServiceConfigsResponse> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs";
                @Key
                private String serviceName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String string) {
                    super(ServiceManagement.this, "GET", REST_PATH, (Object)null, ListServiceConfigsResponse.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setBearerToken(String string) {
                    return (List)super.setBearerToken(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPp(Boolean bl) {
                    return (List)super.setPp(bl);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public List setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends ServiceManagementRequest<Service> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs/{configId}";
                @Key
                private String serviceName;
                @Key
                private String configId;

                protected Get(String string, String string2) {
                    super(ServiceManagement.this, "GET", REST_PATH, (Object)null, Service.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                    this.configId = Preconditions.checkNotNull(string2, "Required parameter configId must be specified.");
                }

                @Override
                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                @Override
                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setBearerToken(String string) {
                    return (Get)super.setBearerToken(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPp(Boolean bl) {
                    return (Get)super.setPp(bl);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Get setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                public String getConfigId() {
                    return this.configId;
                }

                public Get setConfigId(String string) {
                    this.configId = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends ServiceManagementRequest<Service> {
                private static final String REST_PATH = "v1/services/{serviceName}/configs";
                @Key
                private String serviceName;

                protected Create(String string, Service service) {
                    super(ServiceManagement.this, "POST", REST_PATH, (Object)service, Service.class);
                    this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setBearerToken(String string) {
                    return (Create)super.setBearerToken(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPp(Boolean bl) {
                    return (Create)super.setPp(bl);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getServiceName() {
                    return this.serviceName;
                }

                public Create setServiceName(String string) {
                    this.serviceName = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Undelete
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services/{serviceName}:undelete";
            @Key
            private String serviceName;

            protected Undelete(String string) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)null, Operation.class);
                this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
            }

            public Undelete set$Xgafv(String string) {
                return (Undelete)super.set$Xgafv(string);
            }

            public Undelete setAccessToken(String string) {
                return (Undelete)super.setAccessToken(string);
            }

            public Undelete setAlt(String string) {
                return (Undelete)super.setAlt(string);
            }

            public Undelete setBearerToken(String string) {
                return (Undelete)super.setBearerToken(string);
            }

            public Undelete setCallback(String string) {
                return (Undelete)super.setCallback(string);
            }

            public Undelete setFields(String string) {
                return (Undelete)super.setFields(string);
            }

            public Undelete setKey(String string) {
                return (Undelete)super.setKey(string);
            }

            public Undelete setOauthToken(String string) {
                return (Undelete)super.setOauthToken(string);
            }

            public Undelete setPp(Boolean bl) {
                return (Undelete)super.setPp(bl);
            }

            public Undelete setPrettyPrint(Boolean bl) {
                return (Undelete)super.setPrettyPrint(bl);
            }

            public Undelete setQuotaUser(String string) {
                return (Undelete)super.setQuotaUser(string);
            }

            public Undelete setUploadType(String string) {
                return (Undelete)super.setUploadType(string);
            }

            public Undelete setUploadProtocol(String string) {
                return (Undelete)super.setUploadProtocol(string);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Undelete setServiceName(String string) {
                this.serviceName = string;
                return this;
            }

            @Override
            public Undelete set(String string, Object object) {
                return (Undelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class TestIamPermissions
        extends ServiceManagementRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+$");
                this.resource = Preconditions.checkNotNull(string, "Required parameter resource must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.RESOURCE_PATTERN.matcher(string).matches(), "Parameter resource must conform to the pattern ^services/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String string) {
                return (TestIamPermissions)super.set$Xgafv(string);
            }

            public TestIamPermissions setAccessToken(String string) {
                return (TestIamPermissions)super.setAccessToken(string);
            }

            public TestIamPermissions setAlt(String string) {
                return (TestIamPermissions)super.setAlt(string);
            }

            public TestIamPermissions setBearerToken(String string) {
                return (TestIamPermissions)super.setBearerToken(string);
            }

            public TestIamPermissions setCallback(String string) {
                return (TestIamPermissions)super.setCallback(string);
            }

            public TestIamPermissions setFields(String string) {
                return (TestIamPermissions)super.setFields(string);
            }

            public TestIamPermissions setKey(String string) {
                return (TestIamPermissions)super.setKey(string);
            }

            public TestIamPermissions setOauthToken(String string) {
                return (TestIamPermissions)super.setOauthToken(string);
            }

            public TestIamPermissions setPp(Boolean bl) {
                return (TestIamPermissions)super.setPp(bl);
            }

            public TestIamPermissions setPrettyPrint(Boolean bl) {
                return (TestIamPermissions)super.setPrettyPrint(bl);
            }

            public TestIamPermissions setQuotaUser(String string) {
                return (TestIamPermissions)super.setQuotaUser(string);
            }

            public TestIamPermissions setUploadType(String string) {
                return (TestIamPermissions)super.setUploadType(string);
            }

            public TestIamPermissions setUploadProtocol(String string) {
                return (TestIamPermissions)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String string) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.RESOURCE_PATTERN.matcher(string).matches(), "Parameter resource must conform to the pattern ^services/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public TestIamPermissions set(String string, Object object) {
                return (TestIamPermissions)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SetIamPolicy
        extends ServiceManagementRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+$");
                this.resource = Preconditions.checkNotNull(string, "Required parameter resource must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.RESOURCE_PATTERN.matcher(string).matches(), "Parameter resource must conform to the pattern ^services/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String string) {
                return (SetIamPolicy)super.set$Xgafv(string);
            }

            public SetIamPolicy setAccessToken(String string) {
                return (SetIamPolicy)super.setAccessToken(string);
            }

            public SetIamPolicy setAlt(String string) {
                return (SetIamPolicy)super.setAlt(string);
            }

            public SetIamPolicy setBearerToken(String string) {
                return (SetIamPolicy)super.setBearerToken(string);
            }

            public SetIamPolicy setCallback(String string) {
                return (SetIamPolicy)super.setCallback(string);
            }

            public SetIamPolicy setFields(String string) {
                return (SetIamPolicy)super.setFields(string);
            }

            public SetIamPolicy setKey(String string) {
                return (SetIamPolicy)super.setKey(string);
            }

            public SetIamPolicy setOauthToken(String string) {
                return (SetIamPolicy)super.setOauthToken(string);
            }

            public SetIamPolicy setPp(Boolean bl) {
                return (SetIamPolicy)super.setPp(bl);
            }

            public SetIamPolicy setPrettyPrint(Boolean bl) {
                return (SetIamPolicy)super.setPrettyPrint(bl);
            }

            public SetIamPolicy setQuotaUser(String string) {
                return (SetIamPolicy)super.setQuotaUser(string);
            }

            public SetIamPolicy setUploadType(String string) {
                return (SetIamPolicy)super.setUploadType(string);
            }

            public SetIamPolicy setUploadProtocol(String string) {
                return (SetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String string) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.RESOURCE_PATTERN.matcher(string).matches(), "Parameter resource must conform to the pattern ^services/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public SetIamPolicy set(String string, Object object) {
                return (SetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ServiceManagementRequest<ListServicesResponse> {
            private static final String REST_PATH = "v1/services";
            @Key
            private Integer pageSize;
            @Key
            private String producerProjectId;
            @Key
            private String pageToken;

            protected List() {
                super(ServiceManagement.this, "GET", REST_PATH, (Object)null, ListServicesResponse.class);
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setBearerToken(String string) {
                return (List)super.setBearerToken(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPp(Boolean bl) {
                return (List)super.setPp(bl);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            public String getProducerProjectId() {
                return this.producerProjectId;
            }

            public List setProducerProjectId(String string) {
                this.producerProjectId = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetIamPolicy
        extends ServiceManagementRequest<Policy> {
            private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String string, GetIamPolicyRequest getIamPolicyRequest) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)getIamPolicyRequest, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^services/[^/]+$");
                this.resource = Preconditions.checkNotNull(string, "Required parameter resource must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.RESOURCE_PATTERN.matcher(string).matches(), "Parameter resource must conform to the pattern ^services/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String string) {
                return (GetIamPolicy)super.set$Xgafv(string);
            }

            public GetIamPolicy setAccessToken(String string) {
                return (GetIamPolicy)super.setAccessToken(string);
            }

            public GetIamPolicy setAlt(String string) {
                return (GetIamPolicy)super.setAlt(string);
            }

            public GetIamPolicy setBearerToken(String string) {
                return (GetIamPolicy)super.setBearerToken(string);
            }

            public GetIamPolicy setCallback(String string) {
                return (GetIamPolicy)super.setCallback(string);
            }

            public GetIamPolicy setFields(String string) {
                return (GetIamPolicy)super.setFields(string);
            }

            public GetIamPolicy setKey(String string) {
                return (GetIamPolicy)super.setKey(string);
            }

            public GetIamPolicy setOauthToken(String string) {
                return (GetIamPolicy)super.setOauthToken(string);
            }

            public GetIamPolicy setPp(Boolean bl) {
                return (GetIamPolicy)super.setPp(bl);
            }

            public GetIamPolicy setPrettyPrint(Boolean bl) {
                return (GetIamPolicy)super.setPrettyPrint(bl);
            }

            public GetIamPolicy setQuotaUser(String string) {
                return (GetIamPolicy)super.setQuotaUser(string);
            }

            public GetIamPolicy setUploadType(String string) {
                return (GetIamPolicy)super.setUploadType(string);
            }

            public GetIamPolicy setUploadProtocol(String string) {
                return (GetIamPolicy)super.setUploadProtocol(string);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String string) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.RESOURCE_PATTERN.matcher(string).matches(), "Parameter resource must conform to the pattern ^services/[^/]+$");
                }
                this.resource = string;
                return this;
            }

            @Override
            public GetIamPolicy set(String string, Object object) {
                return (GetIamPolicy)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GetConfig
        extends ServiceManagementRequest<Service> {
            private static final String REST_PATH = "v1/services/{serviceName}/config";
            @Key
            private String serviceName;
            @Key
            private String configId;

            protected GetConfig(String string) {
                super(ServiceManagement.this, "GET", REST_PATH, (Object)null, Service.class);
                this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetConfig set$Xgafv(String string) {
                return (GetConfig)super.set$Xgafv(string);
            }

            public GetConfig setAccessToken(String string) {
                return (GetConfig)super.setAccessToken(string);
            }

            public GetConfig setAlt(String string) {
                return (GetConfig)super.setAlt(string);
            }

            public GetConfig setBearerToken(String string) {
                return (GetConfig)super.setBearerToken(string);
            }

            public GetConfig setCallback(String string) {
                return (GetConfig)super.setCallback(string);
            }

            public GetConfig setFields(String string) {
                return (GetConfig)super.setFields(string);
            }

            public GetConfig setKey(String string) {
                return (GetConfig)super.setKey(string);
            }

            public GetConfig setOauthToken(String string) {
                return (GetConfig)super.setOauthToken(string);
            }

            public GetConfig setPp(Boolean bl) {
                return (GetConfig)super.setPp(bl);
            }

            public GetConfig setPrettyPrint(Boolean bl) {
                return (GetConfig)super.setPrettyPrint(bl);
            }

            public GetConfig setQuotaUser(String string) {
                return (GetConfig)super.setQuotaUser(string);
            }

            public GetConfig setUploadType(String string) {
                return (GetConfig)super.setUploadType(string);
            }

            public GetConfig setUploadProtocol(String string) {
                return (GetConfig)super.setUploadProtocol(string);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public GetConfig setServiceName(String string) {
                this.serviceName = string;
                return this;
            }

            public String getConfigId() {
                return this.configId;
            }

            public GetConfig setConfigId(String string) {
                this.configId = string;
                return this;
            }

            @Override
            public GetConfig set(String string, Object object) {
                return (GetConfig)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ServiceManagementRequest<ManagedService> {
            private static final String REST_PATH = "v1/services/{serviceName}";
            @Key
            private String serviceName;

            protected Get(String string) {
                super(ServiceManagement.this, "GET", REST_PATH, (Object)null, ManagedService.class);
                this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Get setServiceName(String string) {
                this.serviceName = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GenerateConfigReport
        extends ServiceManagementRequest<GenerateConfigReportResponse> {
            private static final String REST_PATH = "v1/services:generateConfigReport";

            protected GenerateConfigReport(GenerateConfigReportRequest generateConfigReportRequest) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)generateConfigReportRequest, GenerateConfigReportResponse.class);
            }

            public GenerateConfigReport set$Xgafv(String string) {
                return (GenerateConfigReport)super.set$Xgafv(string);
            }

            public GenerateConfigReport setAccessToken(String string) {
                return (GenerateConfigReport)super.setAccessToken(string);
            }

            public GenerateConfigReport setAlt(String string) {
                return (GenerateConfigReport)super.setAlt(string);
            }

            public GenerateConfigReport setBearerToken(String string) {
                return (GenerateConfigReport)super.setBearerToken(string);
            }

            public GenerateConfigReport setCallback(String string) {
                return (GenerateConfigReport)super.setCallback(string);
            }

            public GenerateConfigReport setFields(String string) {
                return (GenerateConfigReport)super.setFields(string);
            }

            public GenerateConfigReport setKey(String string) {
                return (GenerateConfigReport)super.setKey(string);
            }

            public GenerateConfigReport setOauthToken(String string) {
                return (GenerateConfigReport)super.setOauthToken(string);
            }

            public GenerateConfigReport setPp(Boolean bl) {
                return (GenerateConfigReport)super.setPp(bl);
            }

            public GenerateConfigReport setPrettyPrint(Boolean bl) {
                return (GenerateConfigReport)super.setPrettyPrint(bl);
            }

            public GenerateConfigReport setQuotaUser(String string) {
                return (GenerateConfigReport)super.setQuotaUser(string);
            }

            public GenerateConfigReport setUploadType(String string) {
                return (GenerateConfigReport)super.setUploadType(string);
            }

            public GenerateConfigReport setUploadProtocol(String string) {
                return (GenerateConfigReport)super.setUploadProtocol(string);
            }

            @Override
            public GenerateConfigReport set(String string, Object object) {
                return (GenerateConfigReport)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Enable
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services/{serviceName}:enable";
            @Key
            private String serviceName;

            protected Enable(String string, EnableServiceRequest enableServiceRequest) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)enableServiceRequest, Operation.class);
                this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
            }

            public Enable set$Xgafv(String string) {
                return (Enable)super.set$Xgafv(string);
            }

            public Enable setAccessToken(String string) {
                return (Enable)super.setAccessToken(string);
            }

            public Enable setAlt(String string) {
                return (Enable)super.setAlt(string);
            }

            public Enable setBearerToken(String string) {
                return (Enable)super.setBearerToken(string);
            }

            public Enable setCallback(String string) {
                return (Enable)super.setCallback(string);
            }

            public Enable setFields(String string) {
                return (Enable)super.setFields(string);
            }

            public Enable setKey(String string) {
                return (Enable)super.setKey(string);
            }

            public Enable setOauthToken(String string) {
                return (Enable)super.setOauthToken(string);
            }

            public Enable setPp(Boolean bl) {
                return (Enable)super.setPp(bl);
            }

            public Enable setPrettyPrint(Boolean bl) {
                return (Enable)super.setPrettyPrint(bl);
            }

            public Enable setQuotaUser(String string) {
                return (Enable)super.setQuotaUser(string);
            }

            public Enable setUploadType(String string) {
                return (Enable)super.setUploadType(string);
            }

            public Enable setUploadProtocol(String string) {
                return (Enable)super.setUploadProtocol(string);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Enable setServiceName(String string) {
                this.serviceName = string;
                return this;
            }

            @Override
            public Enable set(String string, Object object) {
                return (Enable)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Disable
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services/{serviceName}:disable";
            @Key
            private String serviceName;

            protected Disable(String string, DisableServiceRequest disableServiceRequest) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)disableServiceRequest, Operation.class);
                this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
            }

            public Disable set$Xgafv(String string) {
                return (Disable)super.set$Xgafv(string);
            }

            public Disable setAccessToken(String string) {
                return (Disable)super.setAccessToken(string);
            }

            public Disable setAlt(String string) {
                return (Disable)super.setAlt(string);
            }

            public Disable setBearerToken(String string) {
                return (Disable)super.setBearerToken(string);
            }

            public Disable setCallback(String string) {
                return (Disable)super.setCallback(string);
            }

            public Disable setFields(String string) {
                return (Disable)super.setFields(string);
            }

            public Disable setKey(String string) {
                return (Disable)super.setKey(string);
            }

            public Disable setOauthToken(String string) {
                return (Disable)super.setOauthToken(string);
            }

            public Disable setPp(Boolean bl) {
                return (Disable)super.setPp(bl);
            }

            public Disable setPrettyPrint(Boolean bl) {
                return (Disable)super.setPrettyPrint(bl);
            }

            public Disable setQuotaUser(String string) {
                return (Disable)super.setQuotaUser(string);
            }

            public Disable setUploadType(String string) {
                return (Disable)super.setUploadType(string);
            }

            public Disable setUploadProtocol(String string) {
                return (Disable)super.setUploadProtocol(string);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Disable setServiceName(String string) {
                this.serviceName = string;
                return this;
            }

            @Override
            public Disable set(String string, Object object) {
                return (Disable)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services/{serviceName}";
            @Key
            private String serviceName;

            protected Delete(String string) {
                super(ServiceManagement.this, "DELETE", REST_PATH, (Object)null, Operation.class);
                this.serviceName = Preconditions.checkNotNull(string, "Required parameter serviceName must be specified.");
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setBearerToken(String string) {
                return (Delete)super.setBearerToken(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPp(Boolean bl) {
                return (Delete)super.setPp(bl);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getServiceName() {
                return this.serviceName;
            }

            public Delete setServiceName(String string) {
                this.serviceName = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Create
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/services";

            protected Create(ManagedService managedService) {
                super(ServiceManagement.this, "POST", REST_PATH, (Object)managedService, Operation.class);
            }

            public Create set$Xgafv(String string) {
                return (Create)super.set$Xgafv(string);
            }

            public Create setAccessToken(String string) {
                return (Create)super.setAccessToken(string);
            }

            public Create setAlt(String string) {
                return (Create)super.setAlt(string);
            }

            public Create setBearerToken(String string) {
                return (Create)super.setBearerToken(string);
            }

            public Create setCallback(String string) {
                return (Create)super.setCallback(string);
            }

            public Create setFields(String string) {
                return (Create)super.setFields(string);
            }

            public Create setKey(String string) {
                return (Create)super.setKey(string);
            }

            public Create setOauthToken(String string) {
                return (Create)super.setOauthToken(string);
            }

            public Create setPp(Boolean bl) {
                return (Create)super.setPp(bl);
            }

            public Create setPrettyPrint(Boolean bl) {
                return (Create)super.setPrettyPrint(bl);
            }

            public Create setQuotaUser(String string) {
                return (Create)super.setQuotaUser(string);
            }

            public Create setUploadType(String string) {
                return (Create)super.setUploadType(string);
            }

            public Create setUploadProtocol(String string) {
                return (Create)super.setUploadProtocol(string);
            }

            @Override
            public Create set(String string, Object object) {
                return (Create)super.set(string, object);
            }
        }
    }

    public class Operations {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            ServiceManagement.this.initialize(get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ServiceManagementRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(ServiceManagement.this, "GET", REST_PATH, (Object)null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = Preconditions.checkNotNull(string, "Required parameter name must be specified.");
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.NAME_PATTERN.matcher(string).matches(), "Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setBearerToken(String string) {
                return (Get)super.setBearerToken(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPp(Boolean bl) {
                return (Get)super.setPp(bl);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!ServiceManagement.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument(this.NAME_PATTERN.matcher(string).matches(), "Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

