/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.common.collect;

import endpoints.repackaged.com.google.common.annotations.GwtCompatible;
import endpoints.repackaged.com.google.common.collect.UnmodifiableIterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible
public abstract class AbstractSequentialIterator<T>
extends UnmodifiableIterator<T> {
    @NullableDecl
    private T nextOrNull;

    protected AbstractSequentialIterator(@NullableDecl T firstOrNull) {
        this.nextOrNull = firstOrNull;
    }

    @NullableDecl
    protected abstract T computeNext(T var1);

    @Override
    public final boolean hasNext() {
        return this.nextOrNull != null;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextOrNull;
            return t;
        }
        finally {
            this.nextOrNull = this.computeNext(this.nextOrNull);
        }
    }
}

