/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.common.flogger.backend;

import endpoints.repackaged.com.google.common.flogger.AbstractLogger;
import endpoints.repackaged.com.google.common.flogger.LogSite;
import endpoints.repackaged.com.google.common.flogger.backend.LoggerBackend;
import endpoints.repackaged.com.google.common.flogger.backend.PlatformProvider;
import endpoints.repackaged.com.google.common.flogger.backend.Tags;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public abstract class Platform {
    private static String ANDROID_PLATFORM = "endpoints.repackaged.com.google.common.flogger.backend.android.AndroidPlatform";
    private static String DEFAULT_PLATFORM = "endpoints.repackaged.com.google.common.flogger.backend.system.DefaultPlatform";
    private static final String[] AVAILABLE_PLATFORMS = new String[]{DEFAULT_PLATFORM};

    public static LogCallerFinder getCallerFinder() {
        return LazyHolder.INSTANCE.getCallerFinderImpl();
    }

    protected abstract LogCallerFinder getCallerFinderImpl();

    public static LoggerBackend getBackend(String className) {
        return LazyHolder.INSTANCE.getBackendImpl(className);
    }

    protected abstract LoggerBackend getBackendImpl(String var1);

    public static boolean shouldForceLogging(String loggerName, Level level, boolean isEnabled) {
        return LazyHolder.INSTANCE.shouldForceLoggingImpl(loggerName, level, isEnabled);
    }

    protected boolean shouldForceLoggingImpl(String loggerName, Level level, boolean isEnabled) {
        return false;
    }

    public static Tags getInjectedTags() {
        return LazyHolder.INSTANCE.getInjectedTagsImpl();
    }

    protected Tags getInjectedTagsImpl() {
        return Tags.empty();
    }

    public static long getCurrentTimeNanos() {
        return LazyHolder.INSTANCE.getCurrentTimeNanosImpl();
    }

    protected long getCurrentTimeNanosImpl() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    public static String getConfigInfo() {
        return LazyHolder.INSTANCE.getConfigInfoImpl();
    }

    protected abstract String getConfigInfoImpl();

    static /* synthetic */ String[] access$000() {
        return AVAILABLE_PLATFORMS;
    }

    public static abstract class LogCallerFinder {
        public abstract String findLoggingClass(Class<? extends AbstractLogger<?>> var1);

        public abstract LogSite findLogSite(Class<?> var1, int var2);
    }

    private static final class LazyHolder {
        private static final Platform INSTANCE = LazyHolder.loadFirstAvailablePlatform(Platform.access$000());

        private LazyHolder() {
        }

        private static Platform loadFirstAvailablePlatform(String[] platformClass) {
            StringBuilder errorMessage = new StringBuilder();
            Platform platform = null;
            try {
                platform = PlatformProvider.getPlatform();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            if (platform != null) {
                return platform;
            }
            for (String clazz : platformClass) {
                try {
                    return (Platform)Class.forName(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    errorMessage.append('\n').append(clazz).append(": ").append(e);
                }
            }
            throw new IllegalStateException(errorMessage.insert(0, "No logging platforms found:").toString());
        }
    }
}

