/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.common.flogger.parameter;

import endpoints.repackaged.com.google.common.flogger.backend.FormatChar;
import endpoints.repackaged.com.google.common.flogger.backend.FormatOptions;
import endpoints.repackaged.com.google.common.flogger.parameter.Parameter;
import endpoints.repackaged.com.google.common.flogger.parameter.ParameterVisitor;
import endpoints.repackaged.com.google.common.flogger.util.Checks;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public final class SimpleParameter
extends Parameter {
    private static final int MAX_CACHED_PARAMETERS = 10;
    private static final Map<FormatChar, SimpleParameter[]> DEFAULT_PARAMETERS;
    private final FormatChar formatChar;
    private final String formatString;

    private static SimpleParameter[] createParameterArray(FormatChar formatChar) {
        SimpleParameter[] parameters = new SimpleParameter[10];
        for (int index = 0; index < 10; ++index) {
            parameters[index] = new SimpleParameter(index, formatChar, FormatOptions.getDefault());
        }
        return parameters;
    }

    public static SimpleParameter of(int index, FormatChar formatChar, FormatOptions options) {
        if (index < 10 && options.isDefault()) {
            return DEFAULT_PARAMETERS.get((Object)formatChar)[index];
        }
        return new SimpleParameter(index, formatChar, options);
    }

    private SimpleParameter(int index, FormatChar formatChar, FormatOptions options) {
        super(options, index);
        this.formatChar = Checks.checkNotNull(formatChar, "format char");
        this.formatString = options.isDefault() ? formatChar.getDefaultFormatString() : SimpleParameter.buildFormatString(options, formatChar);
    }

    static String buildFormatString(FormatOptions options, FormatChar formatChar) {
        char c = formatChar.getChar();
        c = options.shouldUpperCase() ? (char)(c & 0xFFFFFFDF) : c;
        return options.appendPrintfOptions(new StringBuilder("%")).append(c).toString();
    }

    @Override
    protected void accept(ParameterVisitor visitor, Object value) {
        visitor.visit(value, this.formatChar, this.getFormatOptions());
    }

    @Override
    public String getFormat() {
        return this.formatString;
    }

    static {
        EnumMap<FormatChar, SimpleParameter[]> map = new EnumMap<FormatChar, SimpleParameter[]>(FormatChar.class);
        for (FormatChar fc : FormatChar.values()) {
            map.put(fc, SimpleParameter.createParameterArray(fc));
        }
        DEFAULT_PARAMETERS = Collections.unmodifiableMap(map);
    }
}

