/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.com.google.common.flogger.parser;

import endpoints.repackaged.com.google.common.flogger.backend.FormatChar;
import endpoints.repackaged.com.google.common.flogger.backend.FormatOptions;
import endpoints.repackaged.com.google.common.flogger.parameter.DateTimeFormat;
import endpoints.repackaged.com.google.common.flogger.parameter.DateTimeParameter;
import endpoints.repackaged.com.google.common.flogger.parameter.Parameter;
import endpoints.repackaged.com.google.common.flogger.parameter.ParameterVisitor;
import endpoints.repackaged.com.google.common.flogger.parameter.SimpleParameter;
import endpoints.repackaged.com.google.common.flogger.parser.MessageBuilder;
import endpoints.repackaged.com.google.common.flogger.parser.ParseException;
import endpoints.repackaged.com.google.common.flogger.parser.PrintfMessageParser;

public class DefaultPrintfMessageParser
extends PrintfMessageParser {
    private static final PrintfMessageParser INSTANCE = new DefaultPrintfMessageParser();

    public static PrintfMessageParser getInstance() {
        return INSTANCE;
    }

    private DefaultPrintfMessageParser() {
    }

    @Override
    public int parsePrintfTerm(MessageBuilder<?> builder, int index, String message, int termStart, int specStart, int formatStart) throws ParseException {
        Parameter parameter;
        int termEnd = formatStart + 1;
        char typeChar = message.charAt(formatStart);
        boolean isUpperCase = (typeChar & 0x20) == 0;
        FormatOptions options = FormatOptions.parse(message, specStart, formatStart, isUpperCase);
        FormatChar formatChar = FormatChar.of(typeChar);
        if (formatChar != null) {
            if (!options.areValidFor(formatChar)) {
                throw ParseException.withBounds("invalid format specifier", message, termStart, termEnd);
            }
            parameter = SimpleParameter.of(index, formatChar, options);
        } else if (typeChar == 't' || typeChar == 'T') {
            if (!options.validate(160, false)) {
                throw ParseException.withBounds("invalid format specification", message, termStart, termEnd);
            }
            if (++termEnd > message.length()) {
                throw ParseException.atPosition("truncated format specifier", message, termStart);
            }
            DateTimeFormat dateTimeFormat = DateTimeFormat.of(message.charAt(formatStart + 1));
            if (dateTimeFormat == null) {
                throw ParseException.atPosition("illegal date/time conversion", message, formatStart + 1);
            }
            parameter = DateTimeParameter.of(dateTimeFormat, options, index);
        } else if (typeChar == 'h' || typeChar == 'H') {
            if (!options.validate(160, false)) {
                throw ParseException.withBounds("invalid format specification", message, termStart, termEnd);
            }
            parameter = DefaultPrintfMessageParser.wrapHexParameter(options, index);
        } else {
            throw ParseException.withBounds("invalid format specification", message, termStart, formatStart + 1);
        }
        builder.addParameter(termStart, termEnd, parameter);
        return termEnd;
    }

    private static Parameter wrapHexParameter(final FormatOptions options, int index) {
        return new Parameter(options, index){

            @Override
            protected void accept(ParameterVisitor visitor, Object value) {
                visitor.visit(value.hashCode(), FormatChar.HEX, this.getFormatOptions());
            }

            @Override
            public String getFormat() {
                return options.shouldUpperCase() ? "%H" : "%h";
            }
        };
    }
}

