/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl;

import endpoints.repackaged.org.apache.http.impl.SocketHttpServerConnection;
import endpoints.repackaged.org.apache.http.params.HttpConnectionParams;
import endpoints.repackaged.org.apache.http.params.HttpParams;
import java.io.IOException;
import java.net.Socket;

public class DefaultHttpServerConnection
extends SocketHttpServerConnection {
    public void bind(Socket socket, HttpParams params) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params));
        socket.setSoTimeout(HttpConnectionParams.getSoTimeout(params));
        int linger = HttpConnectionParams.getLinger(params);
        if (linger >= 0) {
            socket.setSoLinger(linger > 0, linger);
        }
        super.bind(socket, params);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.getRemotePort());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

