/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.client;

import endpoints.repackaged.org.apache.http.annotation.GuardedBy;
import endpoints.repackaged.org.apache.http.annotation.ThreadSafe;
import endpoints.repackaged.org.apache.http.auth.AuthScope;
import endpoints.repackaged.org.apache.http.auth.Credentials;
import endpoints.repackaged.org.apache.http.client.CredentialsProvider;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class BasicCredentialsProvider
implements CredentialsProvider {
    @GuardedBy(value="this")
    private final HashMap<AuthScope, Credentials> credMap = new HashMap();

    @Override
    public synchronized void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        this.credMap.put(authscope, credentials);
    }

    private static Credentials matchCredentials(HashMap<AuthScope, Credentials> map, AuthScope authscope) {
        Credentials creds = map.get(authscope);
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScope bestMatch = null;
            for (AuthScope current : map.keySet()) {
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = map.get(bestMatch);
            }
        }
        return creds;
    }

    @Override
    public synchronized Credentials getCredentials(AuthScope authscope) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        return BasicCredentialsProvider.matchCredentials(this.credMap, authscope);
    }

    public String toString() {
        return this.credMap.toString();
    }

    @Override
    public synchronized void clear() {
        this.credMap.clear();
    }
}

