/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.conn;

import endpoints.repackaged.org.apache.commons.logging.Log;
import endpoints.repackaged.org.apache.commons.logging.LogFactory;
import endpoints.repackaged.org.apache.http.Header;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpHost;
import endpoints.repackaged.org.apache.http.HttpRequest;
import endpoints.repackaged.org.apache.http.HttpResponse;
import endpoints.repackaged.org.apache.http.HttpResponseFactory;
import endpoints.repackaged.org.apache.http.annotation.NotThreadSafe;
import endpoints.repackaged.org.apache.http.conn.OperatedClientConnection;
import endpoints.repackaged.org.apache.http.impl.SocketHttpClientConnection;
import endpoints.repackaged.org.apache.http.impl.conn.DefaultResponseParser;
import endpoints.repackaged.org.apache.http.impl.conn.LoggingSessionInputBuffer;
import endpoints.repackaged.org.apache.http.impl.conn.LoggingSessionOutputBuffer;
import endpoints.repackaged.org.apache.http.impl.conn.Wire;
import endpoints.repackaged.org.apache.http.io.HttpMessageParser;
import endpoints.repackaged.org.apache.http.io.SessionInputBuffer;
import endpoints.repackaged.org.apache.http.io.SessionOutputBuffer;
import endpoints.repackaged.org.apache.http.params.HttpParams;
import java.io.IOException;
import java.net.Socket;

@NotThreadSafe
public class DefaultClientConnection
extends SocketHttpClientConnection
implements OperatedClientConnection {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Log headerLog = LogFactory.getLog("endpoints.repackaged.org.apache.http.headers");
    private final Log wireLog = LogFactory.getLog("endpoints.repackaged.org.apache.http.wire");
    private volatile Socket socket;
    private HttpHost targetHost;
    private boolean connSecure;
    private volatile boolean shutdown;

    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    public final boolean isSecure() {
        return this.connSecure;
    }

    public final Socket getSocket() {
        return this.socket;
    }

    public void opening(Socket sock, HttpHost target) throws IOException {
        this.assertNotOpen();
        this.socket = sock;
        this.targetHost = target;
        if (this.shutdown) {
            sock.close();
            throw new IOException("Connection already shutdown");
        }
    }

    public void openCompleted(boolean secure, HttpParams params) throws IOException {
        this.assertNotOpen();
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.connSecure = secure;
        this.bind(this.socket, params);
    }

    public void shutdown() throws IOException {
        this.log.debug("Connection shut down");
        this.shutdown = true;
        super.shutdown();
        Socket sock = this.socket;
        if (sock != null) {
            sock.close();
        }
    }

    public void close() throws IOException {
        this.log.debug("Connection closed");
        super.close();
    }

    protected SessionInputBuffer createSessionInputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        if (buffersize == -1) {
            buffersize = 8192;
        }
        SessionInputBuffer inbuffer = super.createSessionInputBuffer(socket, buffersize, params);
        if (this.wireLog.isDebugEnabled()) {
            inbuffer = new LoggingSessionInputBuffer(inbuffer, new Wire(this.wireLog));
        }
        return inbuffer;
    }

    protected SessionOutputBuffer createSessionOutputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        if (buffersize == -1) {
            buffersize = 8192;
        }
        SessionOutputBuffer outbuffer = super.createSessionOutputBuffer(socket, buffersize, params);
        if (this.wireLog.isDebugEnabled()) {
            outbuffer = new LoggingSessionOutputBuffer(outbuffer, new Wire(this.wireLog));
        }
        return outbuffer;
    }

    protected HttpMessageParser createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new DefaultResponseParser(buffer, null, responseFactory, params);
    }

    public void update(Socket sock, HttpHost target, boolean secure, HttpParams params) throws IOException {
        this.assertOpen();
        if (target == null) {
            throw new IllegalArgumentException("Target host must not be null.");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        if (sock != null) {
            this.socket = sock;
            this.bind(sock, params);
        }
        this.targetHost = target;
        this.connSecure = secure;
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        HttpResponse response = super.receiveResponseHeader();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Receiving response: " + response.getStatusLine());
        }
        if (this.headerLog.isDebugEnabled()) {
            Header[] headers;
            this.headerLog.debug("<< " + response.getStatusLine().toString());
            for (Header header : headers = response.getAllHeaders()) {
                this.headerLog.debug("<< " + header.toString());
            }
        }
        return response;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending request: " + request.getRequestLine());
        }
        super.sendRequestHeader(request);
        if (this.headerLog.isDebugEnabled()) {
            Header[] headers;
            this.headerLog.debug(">> " + request.getRequestLine().toString());
            for (Header header : headers = request.getAllHeaders()) {
                this.headerLog.debug(">> " + header.toString());
            }
        }
    }
}

