/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.io;

import endpoints.repackaged.org.apache.http.Header;
import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpMessage;
import endpoints.repackaged.org.apache.http.ParseException;
import endpoints.repackaged.org.apache.http.ProtocolException;
import endpoints.repackaged.org.apache.http.io.HttpMessageParser;
import endpoints.repackaged.org.apache.http.io.SessionInputBuffer;
import endpoints.repackaged.org.apache.http.message.BasicLineParser;
import endpoints.repackaged.org.apache.http.message.LineParser;
import endpoints.repackaged.org.apache.http.params.HttpParams;
import endpoints.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;
import java.util.ArrayList;

public abstract class AbstractMessageParser
implements HttpMessageParser {
    private final SessionInputBuffer sessionBuffer;
    private final int maxHeaderCount;
    private final int maxLineLen;
    protected final LineParser lineParser;

    public AbstractMessageParser(SessionInputBuffer buffer, LineParser parser, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.sessionBuffer = buffer;
        this.maxHeaderCount = params.getIntParameter("http.connection.max-header-count", -1);
        this.maxLineLen = params.getIntParameter("http.connection.max-line-length", -1);
        this.lineParser = parser != null ? parser : BasicLineParser.DEFAULT;
    }

    public static Header[] parseHeaders(SessionInputBuffer inbuffer, int maxHeaderCount, int maxLineLen, LineParser parser) throws HttpException, IOException {
        int i;
        ArrayList<CharArrayBuffer> headerLines;
        block11: {
            if (inbuffer == null) {
                throw new IllegalArgumentException("Session input buffer may not be null");
            }
            if (parser == null) {
                parser = BasicLineParser.DEFAULT;
            }
            headerLines = new ArrayList<CharArrayBuffer>();
            CharArrayBuffer current = null;
            CharArrayBuffer previous = null;
            do {
                if (current == null) {
                    current = new CharArrayBuffer(64);
                } else {
                    current.clear();
                }
                int l = inbuffer.readLine(current);
                if (l == -1 || current.length() < 1) break block11;
                if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                    char ch;
                    for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                    }
                    if (maxLineLen > 0 && previous.length() + 1 + current.length() - i > maxLineLen) {
                        throw new IOException("Maximum line length limit exceeded");
                    }
                    previous.append(' ');
                    previous.append(current, i, current.length() - i);
                    continue;
                }
                headerLines.add(current);
                previous = current;
                current = null;
            } while (maxHeaderCount <= 0 || headerLines.size() < maxHeaderCount);
            throw new IOException("Maximum header count exceeded");
        }
        Header[] headers = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer = (CharArrayBuffer)headerLines.get(i);
            try {
                headers[i] = parser.parseHeader(buffer);
                continue;
            }
            catch (ParseException ex) {
                throw new ProtocolException(ex.getMessage());
            }
        }
        return headers;
    }

    protected abstract HttpMessage parseHead(SessionInputBuffer var1) throws IOException, HttpException, ParseException;

    public HttpMessage parse() throws IOException, HttpException {
        HttpMessage message = null;
        try {
            message = this.parseHead(this.sessionBuffer);
        }
        catch (ParseException px) {
            throw new ProtocolException(px.getMessage(), px);
        }
        Header[] headers = AbstractMessageParser.parseHeaders(this.sessionBuffer, this.maxHeaderCount, this.maxLineLen, this.lineParser);
        message.setHeaders(headers);
        return message;
    }
}

