/*
 * Decompiled with CFR 0.152.
 */
package endpoints.repackaged.org.apache.http.impl.io;

import endpoints.repackaged.org.apache.http.HttpException;
import endpoints.repackaged.org.apache.http.HttpMessage;
import endpoints.repackaged.org.apache.http.HttpResponseFactory;
import endpoints.repackaged.org.apache.http.NoHttpResponseException;
import endpoints.repackaged.org.apache.http.ParseException;
import endpoints.repackaged.org.apache.http.StatusLine;
import endpoints.repackaged.org.apache.http.impl.io.AbstractMessageParser;
import endpoints.repackaged.org.apache.http.io.SessionInputBuffer;
import endpoints.repackaged.org.apache.http.message.LineParser;
import endpoints.repackaged.org.apache.http.message.ParserCursor;
import endpoints.repackaged.org.apache.http.params.HttpParams;
import endpoints.repackaged.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class HttpResponseParser
extends AbstractMessageParser {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public HttpResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected HttpMessage parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

